% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wms.r
\name{copernicus_wms_details}
\alias{copernicus_wms_details}
\title{Obtain a WMS entry for specific Copernicus marine products}
\usage{
copernicus_wms_details(product, layer, variable)
}
\arguments{
\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{copernicus_products_list}}.}

\item{layer}{The name of a desired layer within a product (type \code{character}). Can be obtained with \code{\link{copernicus_product_details}}.}

\item{variable}{The name of a desired variable in a specific layer of a product (type \code{character}).
Can be obtained with \code{\link{copernicus_product_details}}.}
}
\value{
Returns a \code{tibble} with WMS URLs and descriptors for the specified product.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Web Map Services are not available for all
products and layers. Use this function to obtain URLs of WMS services if any.
}
\note{
WMS functions don't work on systems that don't support GDAL utils
}
\examples{
\donttest{
copernicus_wms_details(
  product  = "GLOBAL_ANALYSISFORECAST_PHY_001_024",
  layer    = "cmems_mod_glo_phy-thetao_anfc_0.083deg_P1D-m",
  variable = "thetao"
)
}
}
\seealso{
Other wms-functions: 
\code{\link{addCopernicusWMSTiles}()},
\code{\link{copernicus_wms2geotiff}()}
}
\author{
Pepijn de Vries
}
\concept{wms-functions}
