% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimMultinomial.R
\name{SimMultinomial}
\alias{SimMultinomial}
\title{Simulation of multinomial clustered data}
\usage{
SimMultinomial(
  parC,
  parM,
  clu,
  xc = NULL,
  xm = NULL,
  family,
  rot = 0,
  dfC = NULL,
  offset = NULL
)
}
\arguments{
\item{parC}{copula parameters}

\item{parM}{matrix of dimension (L-1)x k2 of margin parameters; L is the number of levels and k2 is the number of covariates+constant for the margins}

\item{clu}{vector of clusters (can be a factor)}

\item{xc}{matrix of covariates for the copula, not including the constant (can be NULL)}

\item{xm}{matrix  of covariates for the margins, not including the constant (can be NULL)}

\item{family}{copula family: "gaussian" , "t" , "clayton" ,  "joe", "frank" , "gumbel", "plackett"}

\item{rot}{rotation: 0 (default), 90, 180 (survival), or 270}

\item{dfC}{degrees of freedom for student copula (default is NULL)}

\item{offset}{offset for the margins (default is NULL)}
}
\value{
\item{y}{Simulated factor}
}
\description{
Generate a random sample of multinomial observations from a copula-based mixed regression model.
}
\examples{
K=50 #number of clusters
n=5  #size of each cluster
N=n*K
set.seed(1)
clu=rep(c(1:K),each=n)
parC = 2
parM=matrix(c(1,-1,0.5,2),byrow=TRUE,ncol=2)
xm = runif(N)
y=SimMultinomial(parC,parM,clu,xm=xm,family="clayton",rot=90)
}
\author{
Bruno N. Remillard
}
