% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multihyper.R
\name{pmultinom}
\alias{pmultinom}
\title{The Multinomial Distribution}
\usage{
pmultinom(x, k, m, w)
}
\arguments{
\item{x}{The quantile of weighted sum.}

\item{k}{The total number of balls drawn from the urn.}

\item{m}{Numeric non-negative vector of length N, specifying the probability
for drawing the ball of each color; is internally normalized to sum 1. Infinite and missing values
are not allowed. N is the number of colors.}

\item{w}{Numeric non-negative vector of length N, specifying the weight of balls of each color.}
}
\value{
This function will return the probablity of \eqn{P(X \le x)}.
}
\description{
The distribution function for the weighted sums of multinomial distribution
}
\details{
This function gives the distribution function for the weighted sums of multinomial
distribution by recursively calling the binomial distribution density function
\code{\link{dbinom}}.
}
\seealso{
\code{\link{dbinom}}, \code{\link{dmultinom}}, \code{\link{rmultinom}}
}
