% Generated by roxygen2 (4.0.2): do not edit by hand
\name{SO.mc.est}
\alias{SO.mc.est}
\title{Order-restricted MLE assuming marginal compatibility}
\usage{
SO.mc.est(cbdata, turn = 1, control = soControl())
}
\arguments{
\item{cbdata}{an object of class \code{\link{CBData}}.}

\item{turn}{integer specifying the peak of the umbrella ordering (see
Details). The default corresponds to a non-decreasing order.}

\item{control}{an optional list of control settings, usually a call to
\code{\link{soControl}}.  See there for the names of the settable control
values and their effect.}
}
\value{
A list with components:

Components \code{Q} and \code{D} are unlikely to be needed by the user.

\item{MLest}{data frame with the maximum likelihood estimates of
\eqn{P(R_i=r|n)}}

\item{Q}{numeric matrix; estimated weights for the mixing distribution}

\item{D}{numeric matrix; directional derivative of the log-likelihood}

\item{loglik}{the achieved value of the log-likelihood}

\item{converge}{a 2-element vector with the achived relative error and
the performed number of iterations}
}
\description{
\code{SO.mc.est} computes the nonparametric maximum likelihood estimate of
the distribution of the number of responses in a cluster \eqn{P(R=r|n)} under
a stochastic ordering constraint. Umbrella ordering can be specified using
the \code{turn} parameter.
}
\details{
Two different algorithms: EM and ISDM are implemented. In general, ISDM (the
default) should be faster, though its performance depends on the tuning
parameter \code{max.directions}: values that are too low or too high slow the
algorithm down.

\code{SO.mc.est} allows extension to an umbrella ordering: \eqn{D_1 \geq^{st}
\cdots \geq^{st} D_k \leq^{st} \cdots \leq^{st} D_n}{D_1 >= \ldots >= D_k <=
\ldots <= D_n} by specifying the value of \eqn{k} as the \code{turn}
parameter. This is an experimental feature, and at this point none of the
other functions can handle umbrella orderings.
}
\examples{
data(shelltox)
 ml <- SO.mc.est(shelltox, control=soControl(eps=0.01, method="ISDM"))
 attr(ml, "converge")

 require(lattice)
 panel.cumsum <- function(x,y,...){
   x.ord <- order(x)
   panel.xyplot(x[x.ord], cumsum(y[x.ord]), ...)}

 xyplot(Prob~NResp|factor(ClusterSize), groups=Trt, data=ml, type="s",
      panel=panel.superpose, panel.groups=panel.cumsum,
      as.table=TRUE, auto.key=list(columns=4, lines=TRUE, points=FALSE),
      xlab="Number of responses", ylab="Cumulative Probability R(R>=r|N=n)",
      ylim=c(0,1.1), main="Stochastically ordered estimates\\n with marginal compatibility")
}
\author{
Aniko Szabo, aszabo@mcw.edu
}
\references{
Szabo A, George EO. (2009) On the Use of Stochastic Ordering to
Test for Trend with Clustered Binary Data. \emph{Biometrika}
}
\seealso{
\code{\link{soControl}}
}
\keyword{models}
\keyword{nonparametric}

