
#' @name PHAT0test
#' @title PHAT0 test dataset
#' @description The CosmoPhotoz package includes the dataset \code{PHAT0test}, containing photometric 
#' data in the astronomical photometric bands u, g, r, i, z, Y, J, H, K, IRAC_1, IRAC_2
#' and the redshift, for 161042 galaxies. The original PHAT0 dataset, containing 169520 was 
#' split in two (\code{\link{PHAT0train}} and \code{\link{PHAT0test}}).
#' @docType data
#' @format A dataframe with 161042 observations on the following on 12 variables, no
#'   NAs. Columns are named as follows:
#'
#' \describe{
#' 
#' \item{\code{redshift}}{The redshift of the galaxy.}
#' \item{\code{u}}{The magnitude of the galaxy in the u band.}
#' \item{\code{g}}{The magnitude of the galaxy in the g band.}
#' \item{\code{r}}{The magnitude of the galaxy in the r band.}
#' \item{\code{i}}{The magnitude of the galaxy in the i band.}
#' \item{\code{z}}{The magnitude of the galaxy in the z band.}
#' \item{\code{Y}}{The magnitude of the galaxy in the Y band.}
#' \item{\code{J}}{The magnitude of the galaxy in the J band.}
#' \item{\code{H}}{The magnitude of the galaxy in the H band.}
#' \item{\code{K}}{The magnitude of the galaxy in the K band.}
#' \item{\code{IRAC_1}}{The magnitude of the galaxy in the IRAC_1 band.}
#' \item{\code{IRAC_2}}{The magnitude of the galaxy in the IRAC_2 band.}
#' 
#' }
#' @source Hildebrandt H., Arnouts S., Capak P., Moustakas L. A., Wolf C., Abdalla
#'   F. B., Assef R. J., Banerji M., et. al (2010), Astronomy&Astrophysics, v.523, p.A31
#' 
#' @keywords datasets
NULL
#' @name PHAT0train
#' @title PHAT0 train dataset
#' @description The CosmoPhotoz package includes the dataset \code{PHAT0train}, containing photometric 
#' data in the astronomical photometric bands u, g, r, i, z, Y, J, H, K, IRAC_1, IRAC_2
#' and the redshift, for 8478 galaxies. The original PHAT0 dataset, containing 169520 was 
#' split in two (\code{\link{PHAT0train}} and \code{\link{PHAT0test}}).
#' @docType data
#' @format A dataframe with 8478 observations on the following on 12 variables, no
#'   NAs. Columns are named as follows:
#'
#' \describe{
#' 
#' \item{\code{redshift}}{The redshift of the galaxy.}
#' \item{\code{u}}{The magnitude of the galaxy in the u band.}
#' \item{\code{g}}{The magnitude of the galaxy in the g band.}
#' \item{\code{r}}{The magnitude of the galaxy in the r band.}
#' \item{\code{i}}{The magnitude of the galaxy in the i band.}
#' \item{\code{z}}{The magnitude of the galaxy in the z band.}
#' \item{\code{Y}}{The magnitude of the galaxy in the Y band.}
#' \item{\code{J}}{The magnitude of the galaxy in the J band.}
#' \item{\code{H}}{The magnitude of the galaxy in the H band.}
#' \item{\code{K}}{The magnitude of the galaxy in the K band.}
#' \item{\code{IRAC_1}}{The magnitude of the galaxy in the IRAC_1 band.}
#' \item{\code{IRAC_2}}{The magnitude of the galaxy in the IRAC_2 band.}
#' 
#' }
#' @source Hildebrandt H., Arnouts S., Capak P., Moustakas L. A., Wolf C., Abdalla
#'   F. B., Assef R. J., Banerji M., et. al (2010), Astronomy&Astrophysics, v.523, p.A31
#' 
#' @keywords datasets
NULL