% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renewalTools.R
\name{renewal.control}
\alias{renewal.control}
\title{Creates the renewal control list}
\usage{
renewal.control(method = "nlminb", maxit = 1000, trace = 1,
  start = NULL, kkt = FALSE, ...)
}
\arguments{
\item{method}{character, one of the optimization methods accepted by
\code{optimx}.}

\item{maxit}{numeric, the maximum number of iterations in the optimization
routine.}

\item{trace}{Non-negative integer. Should tracing information be printed to
the screen.}

\item{start}{(named) numeric, vector of starting values.}

\item{kkt}{locical should the Kuhn, Karush, Tucker optimality conditions be
tested? Default is \code{FALSE} to avoid numerical hessian computation.}

\item{...}{TODO}
}
\value{
a list with the control parameters used by \code{renewal}
}
\description{
Creates the renewal control list used by \code{renewal}.
}
\details{
The function takes the user passed inputs, checks them (todo: actually, it
doesn't!) and returns an appropriate list that is used inside \code{renewal}
by the optimization routine, such as \code{optimx} among others.
}
\keyword{internal}

