% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovEst.hard.R
\name{CovEst.hard}
\alias{CovEst.hard}
\title{Covariance Estimation via Hard Thresholding}
\usage{
CovEst.hard(X, thr = sqrt(log(ncol(X))/nrow(X)), nCV = 10, parallel = FALSE)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix where each row is an observation.}

\item{thr}{user-defined threshold value. If it is a vector of regularization values, it automatically selects one that minimizes cross validation risk.}

\item{nCV}{the number of repetitions for 2-fold random cross validations for each threshold value.}

\item{parallel}{a logical; \code{TRUE} to use half of available cores, \code{FALSE} to do every computation sequentially.}
}
\value{
a named list containing: \describe{
\item{S}{a \eqn{(p\times p)} covariance matrix estimate.}
\item{CV}{a dataframe containing vector of tested threshold values(\code{thr}) and corresponding cross validation scores(\code{CVscore}).}
}
}
\description{
Bickel and Levina (2008) proposed a sparse covariance estimation technique to apply thresholding on off-diagonal elements of
the sample covariance matrix. The entry of sample covariance matrix \eqn{S_{i,j}=0} if \eqn{|S_{i,j}|<=\tau} where \eqn{\tau} is
a thresholding value (\code{thr}). If \code{thr} is rather a vector of regularization parameters, it applies
cross-validation scheme to select an optimal value.
}
\examples{
## generate data from multivariate normal with Identity covariance.
pdim <- 5
data <- matrix(rnorm(10*pdim), ncol=pdim)

## apply 4 different schemes
#  mthr is a vector of regularization parameters to be tested
mthr <- exp(seq(from=log(0.1),to=log(10),length.out=10))

out1 <- CovEst.hard(data, thr=0.1)  # threshold value 0.1
out2 <- CovEst.hard(data, thr=1)    # threshold value 1
out3 <- CovEst.hard(data, thr=10)   # threshold value 10
out4 <- CovEst.hard(data, thr=mthr) # automatic threshold checking

## visualize 4 estimated matrices
gcol <- gray((0:100)/100)
opar <- par(mfrow=c(2,2), pty="s")
image(out1$S[,pdim:1], col=gcol, main="thr=0.1")
image(out2$S[,pdim:1], col=gcol, main="thr=1")
image(out3$S[,pdim:1], col=gcol, main="thr=10")
image(out4$S[,pdim:1], col=gcol, main="automatic")
par(opar)

}
\references{
\insertRef{bickel_covariance_2008}{CovTools}
}
