% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compensations.R
\docType{methods}
\name{compensations}
\alias{compensations}
\alias{compensations.list}
\alias{compensations.list,UserSession-method}
\alias{compensations.show}
\alias{compensations.show,UserSession-method}
\alias{compensations.upload_csv}
\alias{compensations.upload_csv,UserSession-method}
\title{Compensation Endpoints}
\usage{
\S4method{compensations.upload_csv}{UserSession}(UserSession, experiment_id,
  file_path, timeout = UserSession@long_timeout)

\S4method{compensations.list}{UserSession}(UserSession, experiment_id,
  output = "default", timeout = UserSession@short_timeout)

\S4method{compensations.show}{UserSession}(UserSession, experiment_id,
  compensation_id, output = "default", timeout = UserSession@short_timeout)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{file_path}{character representing a file path}

\item{timeout}{integer representing the request timeout time in seconds \strong{[optional]}}

\item{output}{character representing the output format \strong{[optional]}\cr
\emph{- compensations.list : \code{("default", "raw")}}
\emph{- compensations.show : \code{("default", "dataframe", "raw")}}
\emph{- \code{dataframe}: converts the compensation matrix output to a dataframe}}

\item{compensation_id}{integer representing a compensation ID}
}
\description{
Interact with compensation endpoints. Get information about compensations stored in Cytobank. For information about file-internal compensation for an individual FCS file, consult the \link[=fcs_files]{FCS files} endpoints. \href{https://support.cytobank.org/hc/en-us/sections/200867447-Articles-on-Compensation}{Learn more about compensation in Cytobank}.
}
\details{
\code{compensations.upload_csv} Upload a compensation CSV to an experiment.

\code{compensations.list} List all compensations from an experiment. Outputs a formatted list [default] or raw list with all fields present.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{compensations.show} Show compensation details from an experiment.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "dataframe", "raw")}}\cr
\emph{- \code{dataframe}: converts the compensation matrix output to a dataframe}
}
\examples{
\donttest{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
\donttest{compensations.upload_csv(cyto_session, 22, file_path="/path/to/my_compensation.csv")
}
\donttest{# List of all compensations with all fields present, with a compensation matrix dataframe list item
compensations.list(cyto_session, 22)

# Raw list of all compensations with all fields present
compensations.list(cyto_session, 22, output="raw")
}
\donttest{# List form of a compensation
compensations.show(cyto_session, 22, compensation_id=2)

# Compensation dataframe only
compensations.show(cyto_session, 22, compensation_id=2, output="dataframe")
}
}

