% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_single_variable.R
\name{plot.single_variable_explainer}
\alias{plot.single_variable_explainer}
\title{Plots Marginal Model Explanations (Single Variable Responses)}
\usage{
\method{plot}{single_variable_explainer}(x, ...)
}
\arguments{
\item{x}{a single variable exlainer produced with the 'single_variable' function}

\item{...}{other explainers that shall be plotted together}
}
\value{
a ggplot2 object
}
\description{
Function 'plot.single_variable_explainer' plots marginal responses for one or more explainers.
}
\examples{
library("breakDown")
logit <- function(x) exp(x)/(1+exp(x))

HR_glm_model <- glm(left~., data = breakDown::HR_data, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR_data)
expl_glm <- single_variable(explainer_glm, "satisfaction_level", "pdp", trans=logit)
plot(expl_glm)

\dontrun{
library("randomForest")
HR_rf_model <- randomForest(left~., data = breakDown::HR_data, ntree = 100)
explainer_rf  <- explain(HR_rf_model, data = HR_data)
expl_rf  <- single_variable(explainer_rf, variable =  "satisfaction_level", type = "pdp")
plot(expl_rf)

plot(expl_rf, expl_glm)
}

}
