% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_parts.R
\name{predict_parts}
\alias{predict_parts}
\alias{predict_parts_break_down}
\alias{predict_parts_ibreak_down}
\alias{predict_parts_shap}
\alias{predict_parts_oscillations}
\alias{predict_parts_break_down_interactions}
\alias{variable_attribution}
\title{Instance Level Parts of the Model Predictions}
\usage{
predict_parts(explainer, new_observation, ..., type = "break_down")

predict_parts_oscillations(explainer, new_observation, ...)

predict_parts_break_down(explainer, new_observation, ...)

predict_parts_break_down_interactions(explainer, new_observation, ...)

predict_parts_shap(explainer, new_observation, ...)

variable_attribution(explainer, new_observation, ..., type = "break_down")
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the 'explain' function}

\item{new_observation}{a new observarvation for which predictions need to be explained}

\item{...}{other parameters that will be passed to \code{iBreakDown::break_down}}

\item{type}{the type of variable attributions. Either \code{shap}, \code{oscillations}, \code{break_down} or \code{break_down_interactions}.}
}
\value{
Depending on the \code{type} there are different classess of the resulting object.
It's a data frame with calculated average response.
}
\description{
Instance Level Variable Attributions as Break Down or SHAP Explanations.
Model prediction is decomposed into parts that are attributed for particular variables.
From DALEX version 1.0 this function calls the \code{\link[iBreakDown]{break_down}} or
\code{\link[iBreakDown]{shap}} functions from the \code{iBreakDown} package.
Find information how to use this function here: \url{https://pbiecek.github.io/ema/breakDown.html}.
}
\examples{
new_dragon <- data.frame(year_of_birth = 200,
     height = 80,
     weight = 12.5,
     scars = 0,
     number_of_lost_teeth  = 5)

dragon_lm_model4 <- lm(life_length ~ year_of_birth + height +
                                     weight + scars + number_of_lost_teeth,
                       data = dragons)
dragon_lm_explainer4 <- explain(dragon_lm_model4, data = dragons, y = dragons$year_of_birth,
                                label = "model_4v")
dragon_lm_predict4 <- predict_parts_break_down(dragon_lm_explainer4,
                new_observation = new_dragon)
head(dragon_lm_predict4)
plot(dragon_lm_predict4)

\dontrun{
library("ranger")
dragon_ranger_model4 <- ranger(life_length ~ year_of_birth + height +
                                               weight + scars + number_of_lost_teeth,
                                 data = dragons, num.trees = 50)
dragon_ranger_explainer4 <- explain(dragon_ranger_model4, data = dragons, y = dragons$year_of_birth,
                                label = "model_ranger")
dragon_ranger_predict4 <- predict_parts_break_down(dragon_ranger_explainer4,
                                                          new_observation = new_dragon)
head(dragon_ranger_predict4)
plot(dragon_ranger_predict4)
}

}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://pbiecek.github.io/ema/}
}
