% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{boot.alsos}
\alias{boot.alsos}
\title{Bootstrapping function for the ALSOS algorithm}
\usage{
boot.alsos(
  os_form,
  raw_form = ~1,
  data,
  scale_dv = TRUE,
  maxit = 30,
  level = 1,
  process = 1,
  starts = NULL,
  R = 50,
  conf.level = 0.95,
  return = c("data", "boot.obj", "both"),
  ...
)
}
\arguments{
\item{os_form}{A two-sided formula including the independent variables to 
be scaled on the left-hand side.  Optionally, the dependent variable can 
also be scaled.}

\item{raw_form}{A right-sided formula with covariates that will not be 
scaled.}

\item{data}{A data frame.}

\item{scale_dv}{Logical indicating whether the dependent variable should 
be optimally scaled.}

\item{maxit}{Maximum number of iterations of the optimal scaling algorithm.}

\item{level}{Measurement level of the dependent variable 1=Nominal,
2=Ordinal}

\item{process}{Nature of the measurement process: 1=discrete, 2=continuous.
Basically identifies whether tied observations will continue to be tied in
the optimally scaled variale (1) or whether the algorithm can untie the
points (2) subject to the overall measurement constraints in the model.}

\item{starts}{Optional starting values for the optimal scaling algorithm.}

\item{R}{Number of bootstrap samples to be calculated}

\item{conf.level}{Level of confidence for the confidence intervals.}

\item{return}{Whether the aggregated result with percentile confidence intervals, 
the bootstrap object or both should be returned.}

\item{...}{Other arguments to be passed down to \code{lm}.}
}
\value{
A list with either \code{data} and/or \code{boot.obj} entries.
}
\description{
Executes a non-parametric bootstrap for the 
alsos algorithm to get uncertainty estimates
for the optimally scaled values of the 
variables.
}
