% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quote.R
\name{dbQuoteIdentifier}
\alias{dbQuoteIdentifier}
\title{Quote identifiers}
\usage{
dbQuoteIdentifier(conn, x, ...)
}
\arguments{
\item{conn}{A subclass of \linkS4class{DBIConnection}, representing
an active connection to an DBMS.}

\item{x}{A character vector, \link{SQL} or \link{Id} object to quote as identifier.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbQuoteIdentifier()} returns an object that can be coerced to \link{character},
of the same length as the input.
For an empty character vector this function returns a length-0 object.
The names of the input argument are preserved in the output.
An error is raised if the input contains \code{NA},
but not for an empty string.

When passing the returned object again to \code{dbQuoteIdentifier()}
as \code{x}
argument, it is returned unchanged.
Passing objects of class \link{SQL} should also return them unchanged.
(For backends it may be most convenient to return \link{SQL} objects
to achieve this behavior, but this is not required.)
}
\description{
Call this method to generate a string that is suitable for
use in a query as a column or table name, to make sure that you
generate valid SQL and protect against SQL injection attacks. The inverse
operation is \code{\link[=dbUnquoteIdentifier]{dbUnquoteIdentifier()}}.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbQuoteIdentifier")}
}
\section{Specification}{


Calling \code{\link[=dbGetQuery]{dbGetQuery()}} for a query of the format \code{SELECT 1 AS ...}
returns a data frame with the identifier, unquoted, as column name.
Quoted identifiers can be used as table and column names in SQL queries,
in particular in queries like \code{SELECT 1 AS ...}
and \code{SELECT * FROM (SELECT 1) ...}.
The method must use a quoting mechanism that is unambiguously different
from the quoting mechanism used for strings, so that a query like
\code{SELECT ... FROM (SELECT 1 AS ...)}
throws an error if the column names do not match.

The method can quote column names that
contain special characters such as a space,
a dot,
a comma,
or quotes used to mark strings
or identifiers,
if the database supports this.
In any case, checking the validity of the identifier
should be performed only when executing a query,
and not by \code{dbQuoteIdentifier()}.

}

\examples{
# Quoting ensures that arbitrary input is safe for use in a query
name <- "Robert'); DROP TABLE Students;--"
dbQuoteIdentifier(ANSI(), name)

# SQL vectors are always passed through as is
var_name <- SQL("select")
var_name

dbQuoteIdentifier(ANSI(), var_name)

# This mechanism is used to prevent double escaping
dbQuoteIdentifier(ANSI(), dbQuoteIdentifier(ANSI(), name))
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsValid}},
  \code{\link{dbQuoteLiteral}},
  \code{\link{dbQuoteString}},
  \code{\link{dbUnquoteIdentifier}}
}
\concept{DBIResult generics}
