% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcem_cluster_uv.R
\name{dcem_cluster_uv}
\alias{dcem_cluster_uv}
\title{dcem_cluster_uv (univariate data): Part of DCEM package.}
\usage{
dcem_cluster_uv(data, mean_vector, sd_vector, prior_vec, num, iteration_count,
threshold, numrows, numcols)
}
\arguments{
\item{data}{(matrix): The dataset provided by the user (converted to matrix format).}

\item{mean_vector}{(vector): The vector containing the initial means of the Gaussians.}

\item{sd_vector}{(vector): The vector containing the initial standard deviation for the Gaussians. The initial
sd are set to be 1. They are updated during the iterations of the algorithm.}

\item{prior_vec}{(vector): The vector containing the initial priors for the Gaussians. They are initialized
uniformly.}

\item{num}{(numeric): The number of clusters specified by the user. Default value is 2.}

\item{iteration_count}{(numeric): The number of iterations for which the algorithm should run. if the
convergence is not achieved within the specified threshold then the algorithm stops and exits.
Default: 200.}

\item{threshold}{(numeric): A small value to check for convergence (if the estimated mean(s) are within this
specified threshold then the algorithm stops and exit).

\strong{Note: Choosing a very small value (0.0000001) for threshold can increase the runtime substantially
and the algorithm may not converge. On the other hand, choosing a larger value (0.1)
can lead to sub-optimal clustering. Default: 0.00001}.}

\item{numrows}{(numeric): Number of rows in the dataset (After processing the missing values).}

\item{numcols}{(numeric): Number of columns in the dataset (After processing the missing values).}
}
\value{
A list of objects. This list contains parameters associated with the
        Gaussian(s) (posterior probabilities, mean, co-variance/standard-deviation and priors)

\enumerate{
        \item (1) Posterior Probabilities: \strong{sample_out$prob}
        A matrix of posterior-probabilities

        \item (2) Mean(s): \strong{sample_out$mean}

        For univariate data: It is a vector of means. Each element of the vector
        corresponds to one Gaussian.

        \item (3) Standard-deviation(s): \strong{sample_out$sd}

        For univariate data: Vector of standard deviation for the Gaussian(s))

        \item (4) Priors: \strong{sample_out$prior}
        A vector of priors for the Gaussian(s).
        }
}
\description{
Implements the Expectation Maximization algorithm for the univariate data. This function is internally
called by the dcem_train routine.
}
\references{
Hasan Kurban, Mark Jenne, Mehmet M. Dalkilic
(2016) <https://doi.org/10.1007/s41060-017-0062-1>.
}
\author{
Parichit Sharma \email{parishar@iu.edu}, Hasan Kurban, Mark Jenne, Mehmet Dalkilic

This work is partially supported by NCI Grant 1R01CA213466-01.
}
