% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcem_star_cluster_mv.R
\name{dcem_star_cluster_mv}
\alias{dcem_star_cluster_mv}
\title{dcem_star_cluster_mv (multivariate data): Part of DCEM package.}
\usage{
dcem_star_cluster_mv(data, meu, sigma, prior, num_clusters, iteration_count, num_data)
}
\arguments{
\item{data}{(matrix): The dataset provided by the user.}

\item{meu}{(matrix): The matrix containing the initial meu(s).}

\item{sigma}{(list): A list containing the initial covariance matrices.}

\item{prior}{(vector): A vector containing the initial priors.}

\item{num_clusters}{(numeric): The number of clusters specified by the user. Default value is 2.}

\item{iteration_count}{(numeric): The number of iterations for which the algorithm should run, if the
convergence is not achieved then the algorithm stops and exits. Default: 200.}

\item{num_data}{(numeric): Number of rows in the dataset.}
}
\value{
A list of objects. This list contains parameters associated with the
        Gaussian(s) (posterior probabilities, meu, co-variance and priors)

\enumerate{
        \item (1) Posterior Probabilities:  \strong{prob}
        A matrix of posterior-probabilities for the points in the dataset.

        \item (2) Meu: \strong{meu}: A matrix of meu(s). Each row in
        the  matrix corresponds to one meu.

        \item (3) Sigma: Co-variance matrices: \strong{sigma}: List of co-variance
        matrices.

        \item (4) Priors: \strong{prior}: A vector of prior.
        }
}
\description{
Implements the EM* algorithm for multivariate data. This function is called
by the dcem_star_train routine.
}
\references{
Using data to build a better EM: EM* for big data.

Hasan Kurban, Mark Jenne, Mehmet M. Dalkilic
(2016) <https://doi.org/10.1007/s41060-017-0062-1>.
}
\author{
Parichit Sharma \email{parishar@iu.edu}, Hasan Kurban, Mark Jenne, Mehmet Dalkilic

This work is supported by NCI Grant 1R01CA213466-01.
}
