% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcpo_xvt.R
\name{dcpo_xvt}
\alias{dcpo_xvt}
\title{Cross-validation testing for DCPO}
\usage{
dcpo_xvt(
  dcpo_input,
  fold_number = 1,
  number_of_folds = 10,
  fold_seed = 324,
  chime = TRUE,
  ...
)
}
\arguments{
\item{dcpo_input}{a data frame of survey items and marginals generated by \code{DCPOtools::dcpo_setup}}

\item{fold_number}{an integer indicating the number of the fold to treated as test data in the current analysis}

\item{number_of_folds}{an integer indicating the total number of folds}

\item{fold_seed}{a seed for reproducibly randomly assigning observations to folds; when a complete set of k-fold cross-validations is to be performed, the same seed should be used for all}

\item{chime}{play chime when complete?}

\item{...}{arguments to be passed to \code{rstan::stan}. Defaults reset by \code{dcpo} are
described below under details.}
}
\value{
a stanfit object
}
\description{
\code{dcpo_xvt} performs a single cross-validation test for DCPO
}
\details{
\code{dcpo_xvt} performs a single cross-validation test of a DCPO estimation.  To perform
a complete k-fold cross-validation, call it repeatedly, changing only the fold_number argument.
}
\examples{
\donttest{
demsup <- read_csv(system.file("extdata", "all_data_demsupport.csv", package = "DCPOtools"))

demsup_data <- format_dcpo(with_min_yrs(demsup, 3),
                           scale_q = "church_21",
                           scale_cp = 2)

# Single cross-validation test with 25% test set
demsup_xvtest_25pct <- dcpo_xvt(demsup_data,
                           number_of_folds = 4,
                           iter = 150)

# k-fold cross-validation with 10 folds (demsup_kfold_10 will be a list of stanfit objects)
demsup_kfold_10 <- purrr::map(1:10, function(x) {
                              dcpo_xvt(demsup_data,
                                         fold_number = x, # number_of_folds = 10 is the default
                                         iter = 150)
                                         })
}
}
