% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chaotic.ts.R
\name{lorenz.ts}
\alias{lorenz.ts}
\title{Simulation of time series from the Lorenz system}
\usage{
lorenz.ts(sigma.min = 8, sigma.max = 10, rho.min = 25,
  rho.max = 27, beta.min = 1, beta.max = 2.67, xo.min = -14,
  xo.max = -10, yo.min = -13, yo.max = -10, zo.min = 3,
  zo.max = 10, time = seq(0, 100, 0.01), transient = 1000, B = 100,
  doplot = TRUE)
}
\arguments{
\item{sigma.min}{a non-negative integer denoting a lower bound for the parameter \code{sigma} (Default 8).}

\item{sigma.max}{a non-negative integer denoting an upper bound for the parameter \code{sigma} (Default 10).}

\item{rho.min}{a non-negative integer denoting a lower bound for the parameter \code{rho} (Default 25).}

\item{rho.max}{a non-negative integer denoting an upper bound for the parameter \code{rho} (Default 27).}

\item{beta.min}{a non-negative integer denoting a lower bound for the parameter \code{beta} (Default 1).}

\item{beta.max}{a non-negative integer denoting an upper bound for the parameter \code{beta} (Default 2.67).}

\item{xo.min}{a non-negative integer denoting a lower bound for the initial condition \code{xo} (Default -14).}

\item{xo.max}{a non-negative integer denoting an upper bound for the initial condition \code{xo} (Default -10).}

\item{yo.min}{a non-negative integer denoting a lower bound for the initial condition \code{yo} (Default -13).}

\item{yo.max}{a non-negative integer denoting an upper bound for the initial condition \code{yo} (Default -10).}

\item{zo.min}{a non-negative integer denoting a lower bound for the initial condition \code{zo} (Default 3).}

\item{zo.max}{a non-negative integer denoting an upper bound for the initial condition \code{zo} (Default 10).}

\item{time}{a numeric vector denoting the time-lapse and the time-step (Default 'time-lapse' equal to 10001 with a 'time-step' of 0.01 seconds).}

\item{transient}{a non-negative integer denoting the number of observations that will be discarded to ensure that the values of each time serie are in the attractor (Default 1000).}

\item{B}{a non-negative integer denoting the number of series that will be generated for different values of parameters \code{sigma}, \code{rho} and \code{beta}. The number of simulated series must be at least 100 (Default 100).}

\item{doplot}{a logical value denoting if you want to draw a plot \code{TRUE} or not \code{FALSE}. If it is \code{TRUE} shows six graphs: the evolution of the temporal trajectories for the whole period, the attractor and its projections on the Cartesian plane. All of them consider the 'x-coordinate', the 'y-coordinate' and the 'z-coordinate' (Default \code{TRUE}).}
}
\value{
A list containing as many items as series we want to simulate \code{B}. Each of them has the following attributes: the value of the parameter \code{sigma}, the value of the parameter \code{rho}, the value of the parameter \code{beta}, the value of the initial condition \code{xo}, the value of the initial condition \code{yo}, the value of the initial condition \code{zo} and a time serie from the iterated Lorenz system with three columns corresponding to 'x-coordinate', 'y-coordinate' and 'z-coordinate'.
}
\description{
This function simulates time series from the Lorenz system considering the argument set selected by the user. Some values for the parameters and initial conditions may lead to an unstable system that will tend to infinity.
}
\examples{
## Simulates 100 time series from the Lorenz system for different
## values of the parameters sigma, rho and beta in which this system
## exhibits a chaotic behaviour:
ts<-lorenz.ts(sigma.min=10,sigma.max=10,rho.min=27,rho.max=27,beta.min=2.67,
              beta.max=2.67,time=seq(0,10,0.01),transient=100,B=100, doplot=TRUE)
}
\references{
Lorenz, E. 1963 Deterministic nonperiodic flow. Journal of the Atmospheric Sciences 20(2):130-141.
}
\seealso{
\code{\link{logistic.ts}}, \code{\link{henon.ts}}, \code{\link{rossler.ts}}
}
\author{
Julio E. Sandubete, Lorenzo Escot
}
