% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/New_Simu_Gen_1.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate data}
\usage{
simulate_data(Npat, method = 1, mixture = 1, censor = 0)
}
\arguments{
\item{Npat}{A positive integer indicating the number of patients to be simulated.}

\item{method}{A binary value (either 0 or 1). If method is set to 0, the survival times are simulated from a Weibull distribution.
If method is set to 1, the survival times are simulated from a Lognormal distribution. Default value is 1.}

\item{mixture}{A binary value (either 0 or 1). If method is set to 0, the survival times are simulated from a mixture of two 
distributions. If method is set to 1, the survival times are simulated from single distribution. Default value is 1.}

\item{censor}{A binary value (either 0 or 1). If censor is set to 1, survival times of patients will be censored (at roughly 25%).
If censor is set to 0, the survival times of patients will not be censored.
 Default value is 0.}
}
\value{
Returns a list composed of the patients' generated attributes. The covariates are Age, AUC, and CR.
}
\description{
Simulate data
}
\examples{
#Simulate Data for 10 patients
Npat<- 10 
data<-simulate_data(Npat)

}
