% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chmort.R
\name{chmort}
\alias{chmort}
\title{Calculates childhood mortality rates based on survey data.}
\usage{
chmort(
  Data.Name,
  JK = NULL,
  CL = NULL,
  Strata = NULL,
  Cluster = NULL,
  Weight = NULL,
  Date_of_interview = NULL,
  Date_of_birth = NULL,
  Age_at_death = NULL,
  PeriodEnd = NULL,
  Period = NULL,
  Class = NULL
)
}
\arguments{
\item{Data.Name}{The DHS births (BR) dataset or data from other survey with the same format.}

\item{JK}{"Yes" to estimate Jackknife SE.}

\item{CL}{Confidence level to calculate the Confidence Coefficient Z of the Confidence Intervals; default if 95.}

\item{Strata}{Stratification variable if other than "v022".}

\item{Cluster}{Sample cluster variable if other than "v021".}

\item{Weight}{Survey weight variable if other than "v005".}

\item{Date_of_interview}{Date of Interview (CMC) variable if other than "v008".}

\item{Date_of_birth}{Child date of birth (CMC) variable if other than "b3".}

\item{Age_at_death}{Child age at death (in months) variable if other than "b7".}

\item{PeriodEnd}{The end of the exposure period in YYYY-MM format; default is the date of the survey.}

\item{Period}{The study period for mortality in months; default is 60 months (5 years).}

\item{Class}{Allow for domain level indicators.}
}
\value{
Childhood mortality rates (NNMR, PNNMR, IMR, CMR, and U5MR), and precision indicators (SE, RSE, and CI).
}
\description{
\code{chmort} returns childhood mortality rates such as the Neonatal Mortality Rate (NNMR),
Post-neonatal Mortality Rate (PNNMR), Infant Mortality Rate (IMR), Child Mortality Rate (CMR),
and Under-5 Mortality Rate (U5MR)
\code{chmort} returns the Standrad Error (SE), mortality exposure (N), weighted exposure (WN),
Design Effect (DEFT), Relative Standard Error (RSE), and Confidence Interval (CI).
}
\examples{
# Calculate five-year children mortality rates based on ADBR70 data

data("ADBR70")
chmort(
 ADBR70,
 JK = "Yes"
)

# Calculate ten-year children mortality rates based on ADBR70 data

data("ADBR70")
chmort(
 ADBR70,
 JK = "Yes",
 Period = 120
)

# The exposure period ends in June 2011

data("ADBR70")
chmort(
 ADBR70,
 PeriodEnd = "2011-06"
)

}
\author{
Mahmoud Elkasabi.
}
