% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feedback.R
\name{feedback_to_console}
\alias{feedback_to_console}
\title{Print to the console. Internal use only.}
\usage{
feedback_to_console(
  print_this,
  type,
  findme,
  prefix,
  suffix,
  logjs,
  logfile_dir,
  headless = TRUE
)
}
\arguments{
\item{print_this}{(Optional, String, default: "")}

\item{type}{(Optional, String, default: "Info")
E.g. "Warning", "Error". Default: "Info"}

\item{findme}{(Optional, String, default: "")
Recommended with length 10.
String to find the message in the code.
E.g. 10-digit random hex from
\url{https://onlinerandomtools.com/generate-random-hexadecimal-numbers}}

\item{prefix}{Prefix (Optional, String, default: "")
This is useful if print_this is an array/list.
Each entry will then be new row with this prefix.}

\item{suffix}{Suffix (Optional, String, default: "")
Same like prefix but at the end of each line.}

\item{logjs}{(Optional, Boolean, default: FALSE)
If true (default: false) the print_this
string will also be printed to the javascript-console.
This only makes sense, if the gui is active.}

\item{logfile_dir}{(Optional, String, default: "tempdir()")
The absolute path to folder where the logfile will be stored.}

\item{headless}{(Optional, Boolean, default: TRUE)
Indicating, if the function is run only in the console (headless = TRUE)
or on a GUI frontend (headless = FALSE).}
}
\value{
No return value, called for side effects (see description)
}
\description{
Helper function for the feedback function to print
  stuff to the console. Everything will also be added to the logfile.
  Internal use. Use the robust 'feedback' function instead.
}
