% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OM_functions.R
\name{Replace}
\alias{Replace}
\title{Replace an existing Stock, Fleet, Obs, or Imp object}
\usage{
Replace(OM, from, Sub = c("Stock", "Fleet", "Obs", "Imp"), Quiet = F)
}
\arguments{
\item{OM}{An operating model object (class OM) which will be updated with a sub-model from another OM}

\item{from}{The OM object from which the sub-model is being taken}

\item{Sub}{A character string specifying what object type to replace
"Stock", "Fleet", "Obs" or "Imp" (default is all four which is probably not what you want to do)}

\item{Quiet}{Should the function not return a text message}
}
\value{
An object of class OM
}
\description{
A function that replaces a Stock, Fleet, Obs, or Imp object from an 
OM with one from another OM. Mainly used for internal functions.
}
\examples{
\dontrun{
OM <- Replace(OM, fromOM, "Stock")
}

}
\author{
A. Hordyk
}
