% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSE_functions.R
\name{Sub}
\alias{Sub}
\title{Subset MSE object by management procedure (MP) or simulation.}
\usage{
Sub(MSEobj, MPs = NULL, sims = NULL, years = NULL)
}
\arguments{
\item{MSEobj}{A MSE object.}

\item{MPs}{A vector MPs names or MP numbers to subset the MSE object.
Defaults to all MPs.}

\item{sims}{A vector of simulation numbers to subset the MSE object. Can
also be a logical vector. Defaults to all simulations.}

\item{years}{A numeric vector of projection years. Should start at 1 and
increase by one to some value equal or less than the total number of
projection years.}
}
\description{
Subset the MSE object by particular MPs (either MP number or name), or
particular simulations, or a subset of the projection years (e.g., 1: <
projection years).
}
\examples{
\dontrun{
MSE <- runMSE() 
MSE_1 <- Sub(MSE, MPs=1:2)
MSE_1@MPs
MSE_2 <- Sub(MSE, sims=1:10)
MSE_2@nsim
}
}
\author{
A. Hordyk
}
