% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StochasticSRA.R
\name{SRAcomp}
\alias{SRAcomp}
\title{Plot simulation test of Stochastic SRA method}
\usage{
SRAcomp(sim, OM, outfile = NA, maxplot = 10)
}
\arguments{
\item{sim}{The output list object of SRAsim() function.}

\item{OM}{The output object of StochasticSRA() function.}

\item{outfile}{The name of the figure (something.jpg) you wish to make using SRAcomp}

\item{maxplot}{The maximum number of simulations to plot}
}
\description{
Plots simulation variables versus estimation variables for Stochastic SRA methods of conditioning operating models.
}
\examples{
\dontrun{
sim<-SRAsim(testOM,qmult=1,patchy=0.8)
CAA<-sim$CAA
Chist<-sim$Chist
testOM<-StochasticSRA(testOM,CAA,Chist,nsim=30,nits=500)
SRAcomp(sim,testOM) 
}
}
\author{
T. Carruthers (Canadian DFO grant)
}
