% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{addErrorBars}
\alias{addErrorBars}
\title{addErrorBars: Add errorbars to plot.}
\usage{
addErrorBars(xpos, ypos, errorSize, arrowSize = 0.1)
}
\arguments{
\item{xpos}{x-position of data-points}

\item{ypos}{y-position of data-points}

\item{errorSize}{+- size of error bars}

\item{arrowSize}{Width of the errorbar arrow}
}
\value{
Plot
}
\description{
Add error bars to current plot (uses base arrows function).
}
\examples{
# Example 1
plot(c(1, 2), c(450, 500), xlim = c(0.5, 2.5), ylim = c(400, 600), type = "o")
addErrorBars(c(1, 2), c(450, 500), errorSize = c(20, 20))

# Example 2
plot(c(1, 2), c(450, 500), xlim = c(0.5, 2.5), ylim = c(400, 600), type = "o")
addErrorBars(c(1, 2), c(450, 500), errorSize = c(20, 40), arrowSize = 0.2)

}
