% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcFit.R
\name{calculateCostValue}
\alias{calculateCostValue}
\title{calculateCostValue: Calculate RMSE from RT and error data}
\usage{
calculateCostValue(resTh, resOb)
}
\arguments{
\item{resTh}{list containing caf values for comp/incomp conditions (nbins*2*3) and
delta values for comp/incomp conditions (nbins*5). See output from dmcSim (.$caf).}

\item{resOb}{list containing caf values for comp/incomp conditions (n*2*3) and
delta values for comp/incomp conditions (nbins*5). See output from dmcSim ($delta).}
}
\value{
cost value (RMSE)
}
\description{
Calculate cost value (fit) from combination of RT and error rate.
}
\examples{
# Example 1:
resTh <- dmcSim()
resOb <- dmcSim()
cost  <- calculateCostValue(resTh, resOb)

# Example 2:
resTh <- dmcSim()
resOb <- dmcSim(tau = 150)
cost  <- calculateCostValue(resTh, resOb)

}
