% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HANOVA.R
\name{HANOVA}
\alias{HANOVA}
\title{ANOVA applied on harmonic regression}
\usage{
HANOVA(val1, val2, times1, times2, period, norm = TRUE,
  verbose = options("verbose")[[1]])
}
\arguments{
\item{val1}{matrix: data for values in first set. One column per
sample, one row per time point}

\item{val2}{matrix: data for values in second set. One column per
sample, one row per time point}

\item{times1}{vector: times of first set.}

\item{times2}{vector: times of second set.}

\item{period}{numeric: period of the oscillations. Same unit as the
time points in times1 and times2}

\item{norm}{boolean: whether to normalize the time series (division by mean),
prior to the analysis.}

\item{verbose}{boolean: verbosity.}
}
\value{
data frame with columns:
\itemize{
\item{p.value: }{P-value for difference between the two time series}
\item{F: }{F score from the underlying ANOVA test}
\item{diff: }{Measure for the difference between the two fits}
}
}
\description{
Detection of differential between rhythms in two time series using llsq
fits and ANOVA
}
\details{
This test uses general ANOVA to test for differences between two
time series. Therefore the time series are fitted to sine curves with a
fixed period length and free phase and amplitude. In one case phase and
amplitude have two be the same for both series, in the other case phase
and amplitude could differ for the two series.
}

