% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffOsc.R
\name{dodr}
\alias{dodr}
\title{Detection of differences in rhythmic behavior between
two time series sets}
\usage{
dodr(val1, val2, times1, times2 = times1, norm = TRUE, period = 24,
  method = "robust", verbose = options("verbose")[[1]])
}
\arguments{
\item{val1}{matrix: data for values in first set. One column per
sample, one row per time point}

\item{val2}{matrix: data for values in second set. One column per
sample, one row per time point}

\item{times1}{vector: times of first set.}

\item{times2}{vector: times of second set.}

\item{norm}{boolean: whether to normalize the time series (division by mean),
prior to the analysis.}

\item{period}{numeric: period of the oscillations. Same unit as the
time points in times1 and times2}

\item{method}{vector<string>: method(s) to detect differences.
Groups of related methods have additional identifiers.
\cr Elementary methods:
\code{\link{HANOVA}},
\code{\link{harmScaleTest}},
\code{\link{harmNoisePred1}},
\code{\link{harmNoisePred2}},
\code{\link{robustDODR}},
\code{\link{robustHarmScaleTest}})
\cr Groups:
\itemize{
\item{"all"}{All methods}
\item{"robust"}{Combination of robust detection methods
(robustDODR, robustHarmScaleTest)}
\item{"lsq"}{Combination of least square based detetion methods
(HANOVA, HarmScaleTest, HarmNoisePred1, HarmNoisePred2)}
\item{"ANOVA"}{Combination of ANOVA like methods (HANOVA, robustDODR)}
\item{"scaleTest"}{Combination of scaleTest methods
(harmScaleTest, robustHarmScaleTest)}
\item{"harmNoisePred"}{combination of both scaleTest methods to generate a
two sided test}
}}

\item{verbose}{boolean: verbosity.}
}
\value{
A list containing
\itemize{
\item{'p.value.table'}{
A table containing the p-values for all the tests specified by
\code{method}. Each row contains the results for one sample. A column
\code{meta.p.val} is added containing the lowest p-value, corrected for
multiple testing using a beta-distribution based aproach.}
\item{details}{
A list containing the detailed results from the selected methods}
}
}
\description{
Detection of differences in rhythmic behavior between
two time series sets
}
\details{
This method applies a set of different methods on a pair of two
experiments with one measurement matrix each. Samples to compare have to
have the same column in both matrices. Different methods could be selected.
}
\examples{
library(DODR)

#defining the parameters for two sets of oscillations
n=50
testTimes1 <- 0:15*3
testTimes2 <- testTimes1
tp <- length(testTimes1)
per1 <- 24
amp1 <- 0.3
ph1 <- 5
sd1 <- 0.1

per2 <- per1
amp2 <- amp1
ph2 <- ph1+4
sd2 <- sd1

#creating artificial oscillation sets
v1 <- 1 + amp1 * cos((testTimes1 - ph1)/per1*2*pi)
noise1 <- rnorm(length(testTimes1)*n, 0, sd1)
val1 <- matrix(v1 + noise1, ncol=n)

v2 <- 1 + amp2 * cos((testTimes2 - ph2)/per2*2*pi)
noise2 <- rnorm(length(testTimes2)*n, 0, sd2)
val2 <- matrix(v2 + noise2, ncol=n)

# run DODR
dodr <- dodr(val1, val2, testTimes1, testTimes2, 24, method = 'all')
dodr$p.value.table[1:3,]

#create another set with alterations in noise scale
ph2 <- ph1
sd2 <- sd1 * 3

v2 <- 1 + amp2 * cos((testTimes2 - ph2)/per2*2*pi)
noise2 <- rnorm(length(testTimes2)*n, 0, sd2)
val2 <- matrix(v2 + noise2, ncol=n)

dodr <- dodr(val1, val2, testTimes1, testTimes2, 24, method = 'all')
dodr$p.value.table[1:3,]

}

