% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DOYPAColors_functions.R
\name{doypa_palette}
\alias{doypa_palette}
\title{Create a DOYPAColors color palette function}
\usage{
doypa_palette(palette = NULL, reverse = FALSE, ramp = FALSE)
}
\arguments{
\item{palette}{Character string specifying the desired palette name.
Available palettes: list_doypa_pals().}

\item{reverse}{Logical. If 'TRUE', reverses the order of colors in the palette.}

\item{ramp}{Logical. If 'TRUE', the returned function generates a color ramp (interpolation) instead of a vector of colors.}
}
\value{
A function that generates a vector of 'n' colors or a color ramp.
}
\description{
This function creates a function that generates a color vector or ramp of n colors 
for a specified DOYPAColors palette.
}
\examples{
# Create a function for generating colors from the "buzz" palette
get_buzz_palette <- doypa_palette(palette = "buzz")
colors <- get_buzz_palette(5)
preview_doypa_pals(colors = colors, palette = "buzz")
}
