% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPI.R
\docType{package}
\name{DPI-package}
\alias{DPI-package}
\title{DPI: The Directed Prediction Index for Causal Inference from Observational Data}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

The Directed Prediction Index ('DPI') is a quasi-causal inference (causal discovery) method for observational data designed to quantify the relative endogeneity (relative dependence) of outcome (Y) versus predictor (X) variables in regression models. By comparing the proportion of variance explained (R-squared) between the Y-as-outcome model and the X-as-outcome model while controlling for a sufficient number of possible confounders, it can suggest a plausible (admissible) direction of influence from a more exogenous variable (X) to a more endogenous variable (Y). Methodological details are provided at \url{https://psychbruce.github.io/DPI/}. This package also provides functions for data simulation and network analysis (correlation, partial correlation, and Bayesian networks).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://psychbruce.github.io/DPI/}
  \item Report bugs at \url{https://github.com/psychbruce/DPI/issues}
}

}
\author{
\strong{Maintainer}: Han Wu Shuang Bao \email{baohws@foxmail.com} (\href{https://orcid.org/0000-0003-3043-710X}{ORCID})

}
\keyword{internal}
