% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPI.R
\name{cor_network}
\alias{cor_network}
\title{Correlation network plot.}
\usage{
cor_network(
  data,
  index = c("cor", "pcor"),
  show.value = TRUE,
  show.insig = FALSE,
  show.cutoff = FALSE,
  faded = FALSE,
  text.size = 1.2,
  node.group = NULL,
  node.color = NULL,
  edge.color.pos = "#0571B0",
  edge.color.neg = "#CA0020",
  edge.color.insig = "#EEEEEEEE",
  title = NULL,
  file = NULL,
  width = 6,
  height = 4,
  dpi = 500,
  ...
)
}
\arguments{
\item{data}{Data.}

\item{index}{Type of graph: \code{"cor"} (raw correlation network)
or \code{"pcor"} (partial correlation network).
Defaults to \code{"cor"}.}

\item{show.value}{Show correlation coefficients and their significance on edges.
Defaults to \code{TRUE}.}

\item{show.insig}{Show edges with insignificant correlations (\emph{p} > 0.05).
Defaults to \code{FALSE}.
To change significance level, please set the
\code{alpha} parameter (defaults to \code{alpha=0.05}).}

\item{show.cutoff}{Show cut-off values of correlations.
Defaults to \code{FALSE}.}

\item{faded}{Transparency of edges according to the effect size of correlation.
Defaults to \code{FALSE}.}

\item{text.size}{Scalar on the font size of variable labels.
Defaults to \code{1.2}.}

\item{node.group}{A list that indicates which nodes belong together,
with each element of list as a vector of integers identifying the
column numbers of variables that belong together.}

\item{node.color}{A vector with a color for each element in \code{node.group}, or a color for each node.}

\item{edge.color.pos}{Color for (significant) positive correlations.
Defaults to \code{"#0571B0"} (blue in ColorBrewer's RdBu palette).}

\item{edge.color.neg}{Color for (significant) negative correlations.
Defaults to \code{"#CA0020"} (red in ColorBrewer's RdBu palette).}

\item{edge.color.insig}{Color for insignificant correlations.
Defaults to \code{"#EEEEEEEE"} (transparent grey).}

\item{title}{Plot title.}

\item{file}{File name of saved plot (\code{".png"} or \code{".pdf"}).}

\item{width, height}{Width and height (in inches) of saved plot.
Defaults to \code{6} and \code{4}.}

\item{dpi}{Dots per inch (figure resolution). Defaults to \code{500}.}

\item{...}{Other parameters passed to \code{\link[qgraph:qgraph]{qgraph}}.}
}
\value{
Invisibly return a \code{\link[qgraph:qgraph]{qgraph}} object.
}
\description{
Correlation network plot.
}
\examples{
cor_network(airquality)
cor_network(airquality, show.insig=TRUE)

}
