% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatFunctions.R
\name{pooledCovDP}
\alias{pooledCovDP}
\title{Differentially Private Pooled Covariance}
\usage{
pooledCovDP(
  ...,
  eps = 1,
  lower.bound1,
  upper.bound1,
  lower.bound2,
  upper.bound2,
  which.sensitivity = "bounded",
  mechanism = "Laplace",
  delta = 0,
  type.DP = "aDP",
  approx.n.max = FALSE
)
}
\arguments{
\item{...}{Two or more matrices, each with two columns from which to compute
the pooled covariance.}

\item{eps}{Positive real number defining the epsilon privacy budget.}

\item{lower.bound1, lower.bound2}{Real numbers giving the global or public
lower bounds over the first and second columns of all input data,
respectively.}

\item{upper.bound1, upper.bound2}{Real numbers giving the global or public
upper bounds over the first and second columns of all input data,
respectively.}

\item{which.sensitivity}{String indicating which type of sensitivity to use.
Can be one of {'bounded', 'unbounded', 'both'}. If 'bounded' (default),
returns result based on bounded definition for differential privacy. If
'unbounded', returns result based on unbounded definition. If 'both',
returns result based on both methods \insertCite{Kifer2011}{DPpack}. Note
that if 'both' is chosen, each result individually satisfies (eps,
delta)-differential privacy, but may not do so collectively and in
composition. Care must be taken not to violate differential privacy in this
case.}

\item{mechanism}{String indicating which mechanism to use for differential
privacy. Currently the following mechanisms are supported: {'Laplace',
'Gaussian'}. Default is Laplace. See \code{\link{LaplaceMechanism}} and
\code{\link{GaussianMechanism}} for a description of the supported
mechanisms.}

\item{delta}{Nonnegative real number defining the delta privacy parameter. If
0 (default), reduces to eps-DP and the Laplace mechanism is used.}

\item{type.DP}{String indicating the type of differential privacy desired for
the Gaussian mechanism (if selected). Can be either 'pDP' for probabilistic
DP \insertCite{Machanavajjhala2008}{DPpack} or 'aDP' for approximate DP
\insertCite{Dwork2006b}{DPpack}. Note that if 'aDP' is chosen, epsilon must
be strictly less than 1.}

\item{approx.n.max}{Logical indicating whether to approximate n.max (defined
to be the length of the largest input vector) in the computation of the
global sensitivity based on the upper and lower bounds of the data
\insertCite{Liu2019b}{DPpack}. Approximation is best if n.max is very
large.}
}
\value{
Sanitized pooled covariance based on the bounded and/or unbounded
definitions of differential privacy.
}
\description{
This function computes the differentially private pooled covariance from two
or more two-column matrices of data at user-specified privacy levels of
epsilon and delta.
}
\examples{
# Build datasets
D1 <- sort(stats::rnorm(500, mean=3, sd=2))
D2 <- sort(stats::rnorm(500, mean=-1, sd=0.5))
D3 <- sort(stats::rnorm(200, mean=3, sd=2))
D4 <- sort(stats::rnorm(200, mean=-1, sd=0.5))
M1 <- matrix(c(D1, D2), ncol=2)
M2 <- matrix(c(D3, D4), ncol=2)

lb1 <- -3 # 3 std devs below mean
lb2 <- -2.5 # 3 std devs below mean
ub1 <- 9 # 3 std devs above mean
ub2 <- .5 # 3 std devs above mean
# Pooled covariance satisfying (1,0)-differential privacy
private.pooled.cov <- pooledCovDP(M1, M2, eps = 1, lower.bound1 = lb1,
                                  lower.bound2 = lb2, upper.bound1 = ub1,
                                  upper.bound2 = ub2)
private.pooled.cov

# Pooled covariance satisfying approximate (0.9, 0.01)-differential privacy
# and approximating n.max in the sensitivity calculation
private.pooled.cov <- pooledCovDP(M1, M2, eps = 0.9, lower.bound1 = lb1,
                                  lower.bound2 = lb2, upper.bound1 = ub1,
                                  upper.bound2 = ub2, mechanism = 'Gaussian',
                                  delta = 0.01, approx.n.max = TRUE)
private.pooled.cov

}
\references{
\insertRef{Dwork2006a}{DPpack}

\insertRef{Kifer2011}{DPpack}

\insertRef{Machanavajjhala2008}{DPpack}

\insertRef{Dwork2006b}{DPpack}

\insertRef{Liu2019b}{DPpack}
}
