% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_environmentaltransmission.R
\name{simulate_environmentaltransmission}
\alias{simulate_environmentaltransmission}
\title{Simulation of a compartmental infectious disease transmission model illustrating environmental transmission}
\usage{
simulate_environmentaltransmission(S0 = 1000, I0 = 1, E0 = 0,
  tmax = 120, bd = 0.01, be = 0, b = 0, n = 0, g = 1, p = 0,
  c = 0)
}
\arguments{
\item{S0}{initial number of susceptible hosts}

\item{I0}{initial number of infected hosts}

\item{E0}{initial number of pathogen in environment}

\item{tmax}{maximum simulation time, units of months}

\item{bd}{rate of direct transmission}

\item{be}{rate of environmental transmission}

\item{b}{rate of births of hosts}

\item{n}{the rate of natural death of hosts}

\item{g}{the rate at which infected hosts recover/die}

\item{p}{the rate at which infected host shed pathogen in the enviroment}

\item{c}{the rate at which pathogen in the enviroment decays}
}
\value{
This function returns the simulation result as obtained from a call
  to the deSolve ode solver
}
\description{
This model allows for the simulation of an environmentally transmitted infectious disease
}
\details{
A compartmental ID model with several states/compartments
  is simulated as a set of ordinary differential
  equations. The function returns the output from the odesolver as a matrix,
  with one column per compartment/variable. The first column is time.
}
\section{Warning}{

  This function does not perform any error checking. So if you try to do
  something nonsensical (e.g. any negative values or fractions > 1),
  the code will likely abort with an error message
}

\examples{
  # To run the simulation with default parameters just call this function
  result <- simulate_environmentaltransmission()
  # To choose parameter values other than the standard one, specify them e.g. like such
  result <- simulate_environmentaltransmission(S0 = 100, E0 = 1e5,  tmax = 100)
  # You should then use the simulation result returned from the function, e.g. like this:
  plot(result[,1],result[,2],xlab='Time',ylab='Number Susceptible',type='l')
}
\references{
See e.g. the book "Modeling Infectious Diseases in Humans and Animals" by Keeling and Rohani 
for information on models of this type 
see the documentation for the deSolve package for details on ODE solvers
}
\seealso{
The UI of the shiny app 'EnvironmentalTransmission', which is part of this package, contains more details on the model
}
\author{
Andreas Handel
}
