% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_idcharacteristics.R
\name{simulate_idcharacteristics}
\alias{simulate_idcharacteristics}
\title{Simulation of an infectious disease transmission model with multiple compartments}
\usage{
simulate_idcharacteristics(S0 = 1000, P0 = 1, tmax = 300, bP = 0,
  bA = 0, bI = 1/1000, gP = 0.5, gA = 0.5, gI = 0.5, f = 0,
  d = 0)
}
\arguments{
\item{S0}{specifies the initial number of susceptible hosts}

\item{P0}{initial number of infected, pre-symptomatic hosts}

\item{tmax}{maximum simulation time, units depend on choice of units for your
parameters}

\item{bP}{level/rate of infectiousness for hosts in the P compartment}

\item{bA}{level/rate of infectiousness for hosts in the A compartment}

\item{bI}{level/rate of infectiousness for hosts in the I compartment}

\item{gP}{rate at which a person leaves the P compartment, which
is the inverse of the average time spent in that compartment}

\item{gA}{rate at which a person leaves the A compartment}

\item{gI}{rate at which a person leaves the A compartment}

\item{f}{fraction of pre-symptomatic individuals that have an asymptomatic infection}

\item{d}{fraction of symptomatic infected hosts that die due to disease}
}
\value{
The function returns the output from the odesolver as a matrix,
with one column per compartment/variable. The first column is time.
}
\description{
Simulation of a compartmental model with several different compartments:
Susceptibles (S), Infected and Pre-symptomatic (P),
Infected and Asymptomatic (A), Infected and Symptomatic (I),
Recovered and Immune (R) and Dead (D)
}
\details{
A compartmental ID model with several states/compartments
is simulated as a set of ordinary differential equations. The states
are:
**S**: Susceptible, uninfected individuals
**P**: Presymptomatic individuals who are infected and possibly infectious
**A**: Asymptomatic individuals who are infected and possibly infectious
**I**: Sympomatic infected individuals, most likely infectious
**R**: Removed / recovered individuals, no longer infectious or susceptible
**D**: Individuals who have died from the disease
The model app contains detailed information on the processes, but briefly,
susceptible (S) individuals can become infected by presymptomatic (P), asymptomatic (A),
or infected (I) hosts. All infected individuals enter the presymptomatic stage first,
from which they can become symptomatic or asymptomatic. Asymptomatic hosts recover
within some specified duration of time, while infected hosts either recover or die,
thus entering either R or D. Recovered individuals are immune to reinfection.
}
\section{Warning}{

This function does not perform any error checking. So if you try to do
something nonsensical (e.g. have I0 > PopSize or any negative values or fractions > 1),
the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_idcharacteristics()
# To choose parameter values other than the standard one, specify them like such:
result <- simulate_idcharacteristics(S0 = 2000, P0 = 10, tmax = 100, f = 0.1, d = 0.2)
# You should then use the simulation result returned from the function, like this:
plot(result$ts[,"Time"],result$ts[,"S"],xlab='Time',ylab='Number Susceptible',type='l')
}
\references{
See e.g. Keeling and Rohani 2008 for SIR models and the
  documentation for the deSolve package for details on ODE solvers
}
\author{
Andreas Handel
}
