% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSDriver.R
\name{dsConnect}
\alias{dsConnect}
\title{Create a connection to a DataSHIELD-aware data repository}
\usage{
dsConnect(drv, name, restore = NULL, ...)
}
\arguments{
\item{drv}{an object that inherits from \code{\link{DSDriver-class}}.}

\item{name}{Name of the connection, which must be unique among all the DataSHIELD connections.}

\item{restore}{Workspace name to be restored in the newly created DataSHIELD R session.}

\item{...}{authentication arguments needed by the data repository instance; these
typically include `username`, `password`, `token`, `host`, `port`, `dbname`, etc.
For details see the appropriate `DSDriver`.}
}
\description{
Connect to a data repository going through the appropriate authentication procedure.
Some implementations may allow you to have multiple connections open, so you
may invoke this function repeatedly assigning its output to different
objects.
The authentication mechanism is left unspecified, so check the
documentation of individual drivers for details.

\Sexpr[results=rd,stage=render]{DSI:::methods_as_rd("dsConnect")}
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1",
  username = "dsuser", password = "password", url = "https://opal-demo.obiba.org")
con
dsListTables(con)
dsDisconnect(con)
}
}
\seealso{
\code{\link{dsDisconnect}} to disconnect from a data repository.

Other DSDriver generics: 
\code{\link{DSDriver-class}},
\code{\link{dsGetInfo}()}
}
\concept{DSDriver generics}
