% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dssat.R
\name{read_dssat}
\alias{read_dssat}
\title{Reads data from a single DSSAT file}
\usage{
read_dssat(
  file_name,
  col_types = NULL,
  col_names = NULL,
  na_strings = NULL,
  left_justified = "EXCODE",
  guess_max = 10
)
}
\arguments{
\item{file_name}{a character vector of length one that contains the name
of a single DSSAT output file}

\item{col_types}{One of NULL, a cols() specification, or a string.
See \code{\link[readr]{read_fwf}} or \code{vignette("readr")} for
more details.}

\item{col_names}{A character vector of column names; primarily
helpful for cases where there are no white spaces between column
names within the header line}

\item{na_strings}{A character vector containing strings that should be interpreted as
missing values}

\item{left_justified}{A character vector of column names that
should be left justified}

\item{guess_max}{An integer indicating the maximum number of lines
that should be used to guess the type of a column}
}
\value{
a tibble containing the data from the raw DSSAT output
}
\description{
Reads data from a single DSSAT file
}
\examples{

# Extract file path for sample output file path
sample_output <- system.file('extdata','SAMPLE.OUT',package='DSSAT')

read_dssat(sample_output)

}
