% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_filea.R
\name{write_filea}
\alias{write_filea}
\title{Writes data to a single DSSAT file A}
\usage{
write_filea(filea, file_name, drop_duplicate_rows = TRUE)
}
\arguments{
\item{filea}{a tibble containing the data to write to a DSSAT file A}

\item{file_name}{a character vector of length one that contains the name
of a single DSSAT file into which `filea` will be written}

\item{drop_duplicate_rows}{a logical value indicating whether duplicate rows
should be dropped from tier_data}
}
\description{
Writes data to a single DSSAT file A
}
\examples{

# Extract FileA path for sample file
sample_filea <- system.file('extdata','SAMPLE.CRA',package='DSSAT')

filea <- read_filea(sample_filea)

# Create example FileA file path
sample_filea2 <- paste0(tempdir(),'/SAMPLE.CRA')

# Write out sample FileA
write_filea(filea,sample_filea2)

}
