% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_threshold_probs.R
\name{calculate_threshold_probs}
\alias{calculate_threshold_probs}
\title{Calculate threshold exceedance probabilities}
\usage{
calculate_threshold_probs(max_min_values_list, Dp, Dt_max = TRUE)
}
\arguments{
\item{max_min_values_list}{A list generated by \code{\link[=get_max_min_values]{get_max_min_values()}}}

\item{Dp}{A vector of threshold values to calculate the probabilities for.}

\item{Dt_max}{A logical value indicating whether the decision threshold
is a maximum (\code{TRUE}) or a minimum (\code{FALSE}). The default is \code{TRUE}.}
}
\value{
A list of vectors of threshold values and corresponding
probabilities.
}
\description{
For each policy alternative, this function calculates the
probability that the peak (or minimum) value exceeds (or is below)
a specified threshold(s) using a Riemann sum approach.
}
\examples{
tmin <- "2021-01-01"
tmax <- "2021-04-10"
D <- 750
Dp <- c(750, 1000, 2000)

peak_values_list <- get_max_min_values(
  psa_data,
  tmin = tmin,
  tmax = tmax,
  Dt_max = TRUE
)

calculate_threshold_probs(
  peak_values_list,
  Dp = Dp,
  Dt_max = TRUE
)
}
