% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coord_comparison.R
\name{Coord_comparison}
\alias{Coord_comparison}
\title{Raster coordinates comparison}
\usage{
Coord_comparison(r1, r2)
}
\arguments{
\item{r1}{raster or data frame. If it is a data frame, it should contain in the first two columns, the X, Y 
coordinates for every point, in GEOGRAPHIC COORDINATES, the third column and so on should have the variable values,
and optionally, the header should have the date, using the format \code{\%m/\%Y}.}

\item{r2}{raster or data frame. If it is a data frame, it should contain in the first two columns, the X, Y 
coordinates for every point, in GEOGRAPHIC COORDINATES, the third column and so on should have the variable values,
and optionally, the header should have the date, using the format \code{\%m/\%Y}.}
}
\value{
It prints on console whether the two rasters are on the same coordinates or not, and return
a boolean, TRUE if the rasters are on the same coordinates, and FALSE if not.
}
\description{
This function compares three characteristics from two rasters:
coordinates, resolution, and number of layers (if the rasters have more than one) 
from two different rasters stacks, and let to know if they are using the same geographical information,
or if a new set-up should be done.
}
\examples{
data(P_sogamoso, PET_sogamoso)
Coord_comparison(P_sogamoso, PET_sogamoso)

}
\author{
Pedro Felipe Arboleda Obando <pfarboledao@unal.edu.co>  \cr
Nicolas Duque Gardeazabal <nduqueg@unal.edu.co>  \cr
Carolina Vega Viviescas <cvegav@unal.edu.co> \cr
David Zamora <dazamoraa@unal.edu.co> \cr

Water Resources Engineering Research Group - GIREH
Universidad Nacional de Colombia - sede Bogota
}
