% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_missing.r
\name{plot_missing}
\alias{plot_missing}
\alias{PlotMissing}
\title{Plot missing value profile}
\usage{
plot_missing(data, title = NULL)
}
\arguments{
\item{data}{input data to be profiled, in either \link{data.frame} or \link{data.table} format.}

\item{title}{plot title}
}
\value{
missing value information, such as frequency, percentage and suggested action.
}
\description{
This function returns and plots frequency of missing values for each feature.
}
\details{
The returned object is suppressed by \link{invisible}.
}
\examples{
# load packages
library(data.table)

# manipulate data
dt <- data.table(iris)
for (j in 1:4) set(dt, i = sample(150, j * 30), j, value = NA_integer_)

# plot and assign missing value information
na_profile <- plot_missing(dt)
na_profile
}
\keyword{plot_missing}
