% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scatterplot.r
\name{plot_scatterplot}
\alias{plot_scatterplot}
\title{Create scatterplot for all features}
\usage{
plot_scatterplot(data, by, title = NULL, ...)
}
\arguments{
\item{data}{input data to be plotted, in either \link{data.frame} or \link{data.table} format.}

\item{by}{feature name to be fixed.}

\item{title}{plot title}

\item{\dots}{other arguments to be passed to \link{geom_point}.}
}
\description{
This function creates scatterplot for all features fixing on a selected feature.
}
\examples{
# load mpg data from ggplot2
data("mpg", package = "ggplot2")

# scatterplot mpg dataset by "hwy"
plot_scatterplot(mpg, "hwy", size = 1)
# scatterplot mpg dataset by "class"
plot_scatterplot(mpg, "class", size = 1)
}
\seealso{
\link{geom_point}
}
\keyword{plot_scatterplot}
