% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_report.r
\name{create_report}
\alias{create_report}
\title{Create report}
\usage{
create_report(data, output_format = html_document(toc = TRUE, toc_depth =
  6, theme = "yeti"), output_file = "report.html",
  output_dir = getwd(), y = NULL, config = configure_report(),
  report_title = "Data Profiling Report", ...)
}
\arguments{
\item{data}{input data}

\item{output_format}{output format in \link{render}. Default is \code{html_document(toc = TRUE, toc_depth = 6, theme = "yeti")}.}

\item{output_file}{output file name in \link{render}. Default is "report.html".}

\item{output_dir}{output directory for report in \link{render}. Default is user's current directory.}

\item{y}{name of response variable if any. Response variables will be passed to appropriate plotting functions automatically.}

\item{config}{report configuration generated by \link{configure_report}.}

\item{report_title}{report title. Default is "Data Profiling Report".}

\item{\dots}{other arguments to be passed to \link{render}.}
}
\description{
This function creates a data profiling report.
}
\details{
\code{config} is a named list to be evaluated by \code{create_report}.
Each name should exactly match a function name.
By doing so, that function and corresponding content will be added to the report.
If you do not want to include certain functions/content, do not add it to \code{config}.

\link{configure_report} generates the default template. You may customize the content using that function.

All function arguments will be passed to \link{do.call} as a list.
}
\note{
If both \code{y} and \code{plot_prcomp} are present, \code{y} will be removed from \code{plot_prcomp}.

If there are multiple options for the same function, all of them will be plotted.
For example, \code{create_report(..., y = "a", config = list("plot_bar" = list("with" = "b")))} will create 3 bar charts:
\itemize{
\item regular frequency bar chart
\item bar chart aggregated by response variable "a"
\item bar chart aggregated by `with` variable "b"`
}
}
\examples{
\dontrun{
# Create report
create_report(iris)
create_report(airquality, y = "Ozone")

# Load library
library(ggplot2)
library(data.table)
library(rmarkdown)

# Set some missing values
diamonds2 <- data.table(diamonds)
for (j in 5:ncol(diamonds2)) {
  set(diamonds2,
      i = sample.int(nrow(diamonds2), sample.int(nrow(diamonds2), 1)),
      j,
      value = NA_integer_)
}

# Create customized report for diamonds2 dataset
create_report(
  data = diamonds2,
  output_format = html_document(toc = TRUE, toc_depth = 6, theme = "flatly"),
  output_file = "report.html",
  output_dir = getwd(),
  y = "price",
  config = configure_report(
    add_plot_prcomp = TRUE,
    plot_qq_args = list("by" = "cut", sampled_rows = 1000L),
    plot_bar_args = list("with" = "carat"),
    plot_correlation_args = list("cor_args" = list("use" = "pairwise.complete.obs")),
    plot_boxplot_args = list("by" = "cut"),
    global_ggtheme = quote(theme_light())
  )
)
}
}
\seealso{
\link{configure_report}
}
\keyword{create_report}
