% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataversion.R
\name{data_version}
\alias{data_version}
\alias{dataVersion}
\title{Get the DataVersion for a package}
\usage{
data_version(pkg, lib.loc = NULL)

dataVersion(pkg, lib.loc = NULL)
}
\arguments{
\item{pkg}{\code{character} the package name}

\item{lib.loc}{\code{character} path to library location.}
}
\value{
Object of class 'package_version' and 'numeric_version' specifying the DataVersion of the package
}
\description{
Retrieves the DataVersion of a package if available
}
\note{
\code{dataVersion()} has been renamed to \code{data_version()}
}
\examples{
if(rmarkdown::pandoc_available()){
f <- tempdir()
f <- file.path(f,"foo.Rmd")
con <- file(f)
writeLines("```{r}\n vec = 1:10 \n```\n",con=con)
close(con)
pname <- basename(tempfile())
datapackage_skeleton(name = pname,
   path=tempdir(),
   force = TRUE,
   r_object_names = "vec",
   code_files = f)

   package_build(file.path(tempdir(),pname), install = FALSE)

   devtools::load_all(file.path(tempdir(),pname))
   data_version(pname)
}
}
\seealso{
\code{\link[utils]{packageVersion}}
}
