% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSpaceStudy.R
\docType{class}
\name{DataSpaceStudy}
\alias{DataSpaceStudy}
\title{The DataSpaceStudy class}
\value{
an instance of \code{DataSpaceStudy}
}
\description{
The DataSpaceStudy class

The DataSpaceStudy class
}
\section{Constructor}{

\code{DataSpaceConnection$getStudy()}
\code{DataSpaceConnection$getGroup()}
}

\section{Fields}{

\describe{
  \item{\code{study}}{
    A character. The study name.
  }
  \item{\code{config}}{
    A list. Stores configuration of the connection object such as
    URL, path and username.
  }
  \item{\code{availableDatasets}}{
    A data.table. The table of datasets available in the study object.
  }
  \item{\code{cache}}{
    A list. Stores the data to avoid downloading the same tables multiple
    times.
  }
  \item{\code{treatmentArm}}{
    A data.table. The table of treatment arm information for the connected
    study. Not available for all study connection.
  }
  \item{\code{group}}{
    A character. The group name.
  }
  \item{\code{studyInfo}}{
    A list. Stores the information about the study.
  }
  \item{\code{dataDir}}{
    A character. Default directory for storing nonstandard datasets. Set with
    \code{setDataDir(dataDir)}.
  }
}
}

\section{Methods}{

\describe{
  \item{\code{initialize(study = NULL, config = NULL, group = NULL,
  studyInfo = NULL)}}{
    Initialize \code{DataSpaceStudy} class.
    See \code{\link{DataSpaceConnection}}.
  }
  \item{\code{print()}}{
    Print \code{DataSpaceStudy} class.
  }
  \item{\code{getDataset(datasetName, mergeExtra = FALSE, colFilter = NULL,
  reload = FALSE, outputDir = NULL, ...)}}{
    Get a dataset from the connection.

    \code{datasetName}: A character. Name of the dataset to retrieve.

    \code{mergeExtra}: A logical. If set to TRUE, merge extra information.

    \code{colFilter}: A matrix. A filter as returned by Rlabkey's
    \code{\link[Rlabkey]{makeFilter}}.

    \code{reload}: A logical. If set to TRUE, download the dataset, whether
    a cached version exist or not.

    \code{outputDir}: A character. Optional, specifies directory to download
    nonstandard datasets. If \code{NULL}, data will be downloaded to \code{dataDir},
    set with \code{setDataDir(dataDir)}. If \code{dataDir} is not set, and
    \code{outputDir} is \code{NULL}, a tmp directory will be used.

    \code{...}: Extra arguments to be passed to
    \code{\link[Rlabkey]{labkey.selectRows}}
  }
  \item{\code{clearCache()}}{
    Clear \code{cache}. Remove downloaded datasets.
  }
  \item{\code{getDatasetDescription(datasetName)}}{
    Get variable information.

    \code{datasetName}: A character. Name of the dataset to retrieve.
  }
  \item{\code{setDataDir(dataDir)}}{
    Set default directory to download non-integrated datasets. If no
    dataDir is set, a tmp directory will be used.

    \code{dataDir}: A character. Directory path.

  }
  \item{\code{refresh()}}{
    Refresh the study object to update available datasets and treatment info.
  }
}
}

\examples{
\dontrun{
# Create a connection (Initiate a DataSpaceConnection object)
con <- connectDS()

# Connect to cvd408 (Initiate a DataSpaceStudy object)
# https://dataspace.cavd.org/cds/CAVD/app.view#learn/learn/Study/cvd408?q=408
cvd408 <- con$getStudy("cvd408")
cvd408

# Retrieve Neutralizing antibody dataset (NAb) for cvd408 from DataSpace
NAb <- cvd408$getDataset("NAb")

# Get variable information of the NAb dataset
cvd408$getDatasetDescription("NAb")

# Take a look at cvd408's treatment arm information
cvd408$treatmentArm

# Clear cache of a study object
cvd408$clearCache()

# Connect to the NYVAC durability comparison group
# https://dataspace.cavd.org/cds/CAVD/app.view#group/groupsummary/220
nyvac <- con$getGroup(220)

# Connect to all studies
cvd <- con$getStudy("")

# Refresh the study object to update available datasets and treatment info
cvd$refresh()
}

}
\seealso{
\code{\link{connectDS}} \code{\link{DataSpaceConnection}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DataSpaceStudy$new()}}
\item \href{#method-print}{\code{DataSpaceStudy$print()}}
\item \href{#method-getDataset}{\code{DataSpaceStudy$getDataset()}}
\item \href{#method-clearCache}{\code{DataSpaceStudy$clearCache()}}
\item \href{#method-getDatasetDescription}{\code{DataSpaceStudy$getDatasetDescription()}}
\item \href{#method-refresh}{\code{DataSpaceStudy$refresh()}}
\item \href{#method-setDataDir}{\code{DataSpaceStudy$setDataDir()}}
\item \href{#method-clone}{\code{DataSpaceStudy$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$new(study = NULL, config = NULL, group = NULL, studyInfo = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDataset"></a>}}
\subsection{Method \code{getDataset()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$getDataset(
  datasetName,
  mergeExtra = FALSE,
  colFilter = NULL,
  reload = FALSE,
  outputDir = NULL,
  ...
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clearCache"></a>}}
\subsection{Method \code{clearCache()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$clearCache()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDatasetDescription"></a>}}
\subsection{Method \code{getDatasetDescription()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$getDatasetDescription(datasetName, outputDir = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-refresh"></a>}}
\subsection{Method \code{refresh()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$refresh()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setDataDir"></a>}}
\subsection{Method \code{setDataDir()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$setDataDir(dataDir)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceStudy$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
