% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbExecute,DatabaseConnectorConnection,character-method}
\alias{dbExecute,DatabaseConnectorConnection,character-method}
\title{Execute an update statement, query number of rows affected, and then close result set}
\usage{
\S4method{dbExecute}{DatabaseConnectorConnection,character}(conn, statement,
  ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbExecute()} always returns a
scalar
numeric
that specifies the number of rows affected
by the statement.
An error is raised when issuing a statement over a closed
or invalid connection,
if the syntax of the statement is invalid,
or if the statement is not a non-\code{NA} string.
}
\description{
Executes a statement and returns the number of rows affected.
\code{dbExecute()} comes with a default implementation
(which should work with most backends) that calls
\code{\link[=dbSendStatement]{dbSendStatement()}}, then \code{\link[=dbGetRowsAffected]{dbGetRowsAffected()}}, ensuring that
the result is always free-d by \code{\link[=dbClearResult]{dbClearResult()}}.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbExecute")}
}
\seealso{
For queries: \code{\link[=dbSendQuery]{dbSendQuery()}} and \code{\link[=dbGetQuery]{dbGetQuery()}}.

Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListObjects}},
  \code{\link{dbListResults}}, \code{\link{dbListTables}},
  \code{\link{dbReadTable}}, \code{\link{dbRemoveTable}},
  \code{\link{dbSendQuery}}, \code{\link{dbSendStatement}},
  \code{\link{dbWriteTable}}
}
