% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sql.R
\name{querySql.ffdf}
\alias{querySql.ffdf}
\title{Retrieves data to an ffdf object}
\usage{
querySql.ffdf(connection, sql, errorReportFile = file.path(getwd(),
  "errorReport.txt"))
}
\arguments{
\item{connection}{The connection to the database server.}

\item{sql}{The SQL to be send.}

\item{errorReportFile}{The file where an error report will be written if an error occurs. Defaults to
'errorReport.txt' in the current working directory.}
}
\value{
A ffdf object containing the data. If there are 0 rows, a regular data frame is returned instead
(ffdf cannot have 0 rows)
}
\description{
This function sends SQL to the server, and returns the results in an ffdf object.
}
\details{
Retrieves data from the database server and stores it in an ffdf object. This allows very large
data sets to be retrieved without running out of memory. If an error occurs during SQL execution,
this error is written to a file to facilitate debugging.
}
\examples{
\dontrun{
library(ffbase)
connectionDetails <- createConnectionDetails(dbms = "mysql",
                                             server = "localhost",
                                             user = "root",
                                             password = "blah",
                                             schema = "cdm_v4")
conn <- connect(connectionDetails)
count <- querySql.ffdf(conn, "SELECT COUNT(*) FROM person")
disconnect(conn)
}
}
