% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbClearResult,DatabaseConnectorResult-method}
\alias{dbClearResult,DatabaseConnectorResult-method}
\title{Clear a result set}
\usage{
\S4method{dbClearResult}{DatabaseConnectorResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbClearResult()} returns \code{TRUE}, invisibly, for result sets obtained from
both \code{dbSendQuery()}
and \code{dbSendStatement()}.
An attempt to close an already closed result set issues a warning
in both cases.
}
\description{
Frees all resources (local and remote) associated with a result set.  In some
cases (e.g., very large result sets) this can be a critical step to avoid
exhausting resources (memory, file descriptors, etc.)

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbClearResult")}
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbColumnInfo}},
  \code{\link{dbFetch}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsReadOnly}},
  \code{\link{dbIsValid}}, \code{\link{dbQuoteIdentifier}},
  \code{\link{dbQuoteLiteral}},
  \code{\link{dbQuoteString}},
  \code{\link{dbUnquoteIdentifier}}
}
