/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.TableRow;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import net.starschema.clouddb.jdbc.BQResultsetMetaData;
import net.starschema.clouddb.jdbc.BQSQLException;
import net.starschema.clouddb.jdbc.BQSQLFeatureNotSupportedException;
import net.starschema.clouddb.jdbc.BQSQLXML;
import net.starschema.clouddb.jdbc.BQStatementRoot;
import net.starschema.clouddb.jdbc.BQSupportFuncts;
import net.starschema.clouddb.jdbc.Logger;

public class BQForwardOnlyResultSet
implements ResultSet {
    private static final DateTimeFormatter BQ_STANDARD_TS_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-[M][MM]-[d][dd][' ']['T'][H][HH][':'][m][mm][':'][s][ss]").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).appendPattern("[VV][z][zz][zzz][zzzz]").toFormatter();
    Logger logger = Logger.getLogger(BQForwardOnlyResultSet.class.getName());
    protected InputStream Strm = null;
    protected boolean wasnull = false;
    protected Object[] RowsofResult;
    protected boolean closed = false;
    protected int FETCH_SIZE = 5000;
    protected BigInteger FETCH_POS = BigInteger.ZERO;
    protected boolean AT_FIRST = true;
    private Statement Statementreference;
    private GetQueryResultsResponse Result;
    private Bigquery bigquery;
    private String projectId;
    private Job completedJob;
    private int Cursor = -1;

    public BQForwardOnlyResultSet(Bigquery bigquery, String projectId, Job completedJob, BQStatementRoot bqStatementRoot) throws SQLException {
        this.logger.debug("Created forward only resultset TYPE_FORWARD_ONLY");
        this.Statementreference = (Statement)((Object)bqStatementRoot);
        this.bigquery = bigquery;
        this.completedJob = completedJob;
        this.projectId = projectId;
        try {
            this.Result = BQSupportFuncts.getQueryResultsDivided(bigquery, projectId, completedJob, this.FETCH_POS, this.FETCH_SIZE);
        }
        catch (IOException e) {
            throw new BQSQLException("Failed to retrieve data", e);
        }
        if (this.Result == null) {
            this.RowsofResult = null;
        } else if (this.Result.getRows() == null) {
            this.RowsofResult = null;
        } else {
            this.RowsofResult = this.Result.getRows().toArray();
            this.FETCH_POS = this.FETCH_POS.add(BigInteger.valueOf(this.RowsofResult.length));
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        String result = this.getString(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        String Columntype = this.Result.getSchema().getFields().get(columnIndex - 1).getType();
        try {
            if (Columntype.equals("STRING")) {
                return result;
            }
            if (Columntype.equals("FLOAT")) {
                return this.toDouble(result);
            }
            if (Columntype.equals("BOOLEAN")) {
                return this.toBoolean(result);
            }
            if (Columntype.equals("INTEGER")) {
                return this.toLong(result);
            }
            if (Columntype.equals("TIMESTAMP")) {
                return this.toTimestamp(result, null);
            }
            if (Columntype.equals("DATE")) {
                return this.toDate(result, null);
            }
            throw new BQSQLException("Unsupported Type (" + Columntype + ")");
        }
        catch (NumberFormatException e) {
            throw new BQSQLException(e);
        }
    }

    private Boolean toBoolean(String value) throws SQLException {
        return Boolean.valueOf(value);
    }

    private Double toDouble(String value) throws SQLException {
        try {
            return new BigDecimal(value).doubleValue();
        }
        catch (NumberFormatException e) {
            throw new BQSQLException(e);
        }
    }

    private Long toLong(String value) throws SQLException {
        try {
            return new BigDecimal(value).longValue();
        }
        catch (NumberFormatException e) {
            throw new BQSQLException(e);
        }
    }

    private Timestamp toTimestamp(String value, Calendar cal) throws SQLException {
        try {
            return new Timestamp(Instant.from(BQ_STANDARD_TS_FORMATTER.parse(value)).toEpochMilli());
        }
        catch (DateTimeException e) {
            this.logger.debug("Try legacy timestamp for " + value);
            return this.toLegacyTimestamp(value, cal);
        }
    }

    private Timestamp toLegacyTimestamp(String value, Calendar cal) throws SQLException {
        try {
            long dbValue = new BigDecimal(value).movePointRight(3).longValue();
            if (cal == null) {
                cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            }
            Calendar dbCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            dbCal.setTimeInMillis(dbValue);
            cal.set(1, dbCal.get(1));
            cal.set(2, dbCal.get(2));
            cal.set(5, dbCal.get(5));
            cal.set(11, dbCal.get(11));
            cal.set(12, dbCal.get(12));
            cal.set(13, dbCal.get(13));
            cal.set(14, dbCal.get(14));
            return new Timestamp(cal.getTime().getTime());
        }
        catch (NumberFormatException e) {
            throw new BQSQLException(e);
        }
    }

    private BigDecimal toBigDecimal(String value) {
        return new BigDecimal(value);
    }

    private Date toDate(String value, Calendar cal) throws SQLException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            java.util.Date date = sdf.parse(value);
            return new Date(date.getTime());
        }
        catch (ParseException e) {
            throw new BQSQLException(e);
        }
    }

    private Time toTime(String value, Calendar cal) throws SQLException {
        return new Time(this.toTimestamp(value, cal).getTime());
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.closestrm();
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        if (this.getMetaData().getColumnCount() < columnIndex || columnIndex < 1) {
            throw new BQSQLException("ColumnIndex is not valid");
        }
        if (this.RowsofResult == null) {
            throw new BQSQLException("Invalid position!");
        }
        Object resultObject = ((TableRow)this.RowsofResult[this.Cursor]).getF().get(columnIndex - 1).getV();
        if (Data.isNull(resultObject)) {
            this.wasnull = true;
            return null;
        }
        this.wasnull = false;
        return (String)resultObject;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY, absolute is not supported");
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.getType() == 1003) {
            throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("cancelWorUpdates()");
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is closed");
        }
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        this.RowsofResult = null;
    }

    protected void closestrm() throws SQLException {
        if (this.Strm != null) {
            try {
                this.Strm.close();
            }
            catch (IOException e) {
                throw new BQSQLException(e);
            }
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("deleteRow()");
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        int columncount = this.getMetaData().getColumnCount();
        for (int i = 1; i <= columncount; ++i) {
            if (!this.getMetaData().getColumnName(i).equalsIgnoreCase(columnLabel)) continue;
            return i;
        }
        throw new BQSQLException("No Such column labeled: " + columnLabel);
    }

    @Override
    public boolean first() throws SQLException {
        throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getArray(int)");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getArray(string)");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        ByteArrayInputStream inptstrm;
        this.closestrm();
        String Value2 = this.getString(columnIndex);
        if (Value2 == null) {
            this.wasnull = true;
            this.Strm = null;
            return this.Strm;
        }
        this.wasnull = false;
        try {
            inptstrm = new ByteArrayInputStream(Value2.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new BQSQLException(e);
        }
        this.Strm = inptstrm;
        return this.Strm;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getAsciiStream(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return this.toBigDecimal(value);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal value = this.getBigDecimal(columnIndex);
        if (value == null) {
            return null;
        }
        return value.setScale(scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBigDecimal(columnIndex, scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.closestrm();
        String Value2 = this.getString(columnIndex);
        if (Value2 == null) {
            this.wasnull = true;
            this.Strm = null;
            return this.Strm;
        }
        this.wasnull = false;
        ByteArrayInputStream inptstrm = new ByteArrayInputStream(Value2.getBytes());
        this.Strm = inptstrm;
        return this.Strm;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getBlob(int)");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getBlob(string)");
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (this.wasNull()) {
            return false;
        }
        return this.toBoolean(value);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return 0;
        }
        return this.toLong(Value2).byteValue();
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getByte(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return Value2.getBytes();
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBytes(columnIndex);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.closestrm();
        String Value2 = this.getString(columnIndex);
        if (Value2 == null) {
            this.wasnull = true;
            return null;
        }
        this.wasnull = false;
        StringReader rdr = new StringReader(Value2);
        return rdr;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getClob(int)");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getClob(string)");
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getCursorName()");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return this.toDate(value, null);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        String value = this.getString(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return this.toDate(value, cal);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getDate(columnIndex, cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return 0.0;
        }
        return this.toDouble(Value2);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getDouble(columnIndex);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.FETCH_SIZE;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return 0.0f;
        }
        return this.toDouble(Value2).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getFloat(columnIndex);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return 0;
        }
        return this.toLong(Value2).intValue();
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return 0L;
        }
        return this.toLong(Value2);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getLong(columnIndex);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        return new BQResultsetMetaData(this.Result);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getNClob(int");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getNClob(string)");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getObject(int,Map)");
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getObject(string,Map)");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getRef(int)");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getref(String)");
    }

    @Override
    public int getRow() throws SQLException {
        throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getRowId(int)");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getRowId(String)");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (this.wasNull()) {
            return 0;
        }
        return this.toLong(value).shortValue();
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getShort(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return new BQSQLXML(this.getString(columnIndex));
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getSQLXML(columnIndex);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.Statementreference;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getString(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return this.toTime(value, null);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        String value = this.getString(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return this.toTime(value, cal);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getTime(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return this.toTimestamp(value, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        String value = this.getString(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return this.toTimestamp(value, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getTimestamp(columnIndex, cal);
    }

    @Override
    public int getType() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        return 1003;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("Deprecated. use getCharacterStream in place of getUnicodeStream");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("Deprecated. use getCharacterStream in place of getUnicodeStream");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        try {
            return new URL(Value2);
        }
        catch (MalformedURLException e) {
            throw new BQSQLException(e);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getURL(columnIndex);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("insertRow()");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        throw new BQSQLException("Forward_only resultset doesn't support isAfterLast() ");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        if (this.Cursor == -1) {
            return true;
        }
        throw new BQSQLException("Forward_only resultset doesn't support isBeforeFirst() ");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        return this.AT_FIRST;
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("This Resultset is Closed");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("moveToCurrentRow()");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("moveToInsertRow()");
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        if (this.RowsofResult == null) {
            return false;
        }
        if (this.Cursor < this.FETCH_SIZE && this.Cursor < this.RowsofResult.length - 1) {
            this.AT_FIRST = this.Cursor == -1;
            ++this.Cursor;
            return true;
        }
        try {
            this.Result = BQSupportFuncts.getQueryResultsDivided(this.bigquery, this.projectId, this.completedJob, this.FETCH_POS, this.FETCH_SIZE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.Result.getRows() == null) {
            this.RowsofResult = null;
            return false;
        }
        this.RowsofResult = this.Result.getRows().toArray();
        this.FETCH_POS = this.FETCH_POS.add(BigInteger.valueOf(this.RowsofResult.length));
        this.Cursor = 0;
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("refreshRow()");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new BQSQLException("Not implemented.setFetchDirection(int)");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.FETCH_SIZE = rows;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new BQSQLException("Not implemented.unwrap(Class<T>)");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasnull;
    }
}

