/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.starschema.clouddb.jdbc.BQSQLException;
import net.starschema.clouddb.jdbc.COLResultSetMetadata;
import net.starschema.clouddb.jdbc.Logger;
import net.starschema.clouddb.jdbc.ScrollableResultset;

public class DMDResultSet
extends ScrollableResultset<Object>
implements ResultSet {
    Logger logger;
    DMDResultSetType ResultsetType;
    String[] Colnames = null;

    public DMDResultSet(Object[] objects, String[] colnames, DMDResultSetType type) {
        this.RowsofResult = objects;
        this.Colnames = colnames;
        this.ResultsetType = type;
        this.logger = Logger.getLogger(DMDResultSet.class.getName());
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.Colnames = null;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        for (int i = 0; i < this.Colnames.length; ++i) {
            if (!this.Colnames[i].equals(columnLabel)) continue;
            return i + 1;
        }
        throw new BQSQLException("No such column");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            try {
                Object[][] Containter = (Object[][])Object[][].class.cast(this.RowsofResult);
                String[][] data = null;
                data = Containter.length == 0 ? new String[0][0] : new String[Containter.length][Containter[0].length];
                for (int i = 0; i < Containter.length; ++i) {
                    for (int k = 0; k < Containter[i].length; ++k) {
                        data[i][k] = Containter[i][k] == null ? null : Containter[i][k].toString();
                    }
                }
                return new COLResultSetMetadata(data, this.Colnames, this.ResultsetType);
            }
            catch (ClassCastException e) {
                String[][] data = this.RowsofResult.length == 0 ? new String[0][0] : new String[1][this.RowsofResult.length];
                for (int i = 0; i < this.RowsofResult.length; ++i) {
                    data[0][i] = this.RowsofResult[i] == null ? null : this.RowsofResult[i].toString();
                }
                return new COLResultSetMetadata(data, this.Colnames, this.ResultsetType);
            }
        }
        catch (Exception e) {
            throw new BQSQLException(e);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.logger.debug("Function Call getObject Parameter: " + columnIndex);
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        this.ThrowCursorNotValidExeption();
        if (this.RowsofResult == null) {
            throw new BQSQLException("No Valid Rows");
        }
        if (columnIndex < 1) {
            throw new BQSQLException("ColumnIndex is not valid");
        }
        try {
            Object[][] Containter = (Object[][])Object[][].class.cast(this.RowsofResult);
            if (columnIndex > Containter[this.Cursor].length) {
                throw new BQSQLException("ColumnIndex is not valid");
            }
            if (Containter[this.Cursor][columnIndex - 1] == null) {
                this.wasnull = true;
                this.logger.debug("Returning: null");
            } else {
                this.wasnull = false;
                this.logger.debug("Returning: " + Containter[this.Cursor][columnIndex - 1].toString());
            }
            return Containter[this.Cursor][columnIndex - 1];
        }
        catch (ClassCastException e) {
            if (columnIndex == 1) {
                this.wasnull = this.RowsofResult[this.Cursor] == null;
                this.logger.debug("Returning: " + this.RowsofResult[this.Cursor].toString());
                return this.RowsofResult[this.Cursor];
            }
            throw new BQSQLException(e);
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        this.ThrowCursorNotValidExeption();
        if (this.RowsofResult == null) {
            throw new BQSQLException("No Valid Rows");
        }
        if (columnIndex < 1) {
            throw new BQSQLException("ColumnIndex is not valid");
        }
        try {
            Object[][] Containter = (Object[][])Object[][].class.cast(this.RowsofResult);
            if (columnIndex > Containter[this.Cursor].length) {
                throw new BQSQLException("ColumnIndex is not valid");
            }
            if (Containter[this.Cursor][columnIndex - 1] == null) {
                this.wasnull = true;
                this.logger.debug("Returning: Null");
                return null;
            }
            this.wasnull = false;
            this.logger.debug("Returning: " + Containter[this.Cursor][columnIndex - 1].toString());
            return Containter[this.Cursor][columnIndex - 1].toString();
        }
        catch (ClassCastException e) {
            if (columnIndex == 1) {
                if (this.RowsofResult[this.Cursor] == null) {
                    this.wasnull = true;
                    this.logger.debug("Returning: Null");
                    return null;
                }
                this.wasnull = false;
                this.logger.debug("Returning: " + this.RowsofResult[this.Cursor].toString());
                return this.RowsofResult[this.Cursor].toString();
            }
            throw new BQSQLException("ColumnIndex is not valid");
        }
    }

    public static enum DMDResultSetType {
        getAttributes,
        getBestRowIdentifier,
        getCatalogs,
        getClientInfoProperties,
        getColumnPrivileges,
        getColumns,
        getCrossReference,
        getExportedKeys,
        getFunctionColumns,
        getFunctions,
        getImportedKeys,
        getIndexInfo,
        getPrimaryKeys,
        getProcedureColumns,
        getProcedures,
        getSchemas,
        getSuperTables,
        getSuperTypes,
        getTablePrivileges,
        getTables,
        getTableTypes,
        getTypeInfo,
        getUDTs,
        getVersionColumns;

    }
}

