/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.util.List;
import net.starschema.clouddb.jdbc.JdbcGrammarParser;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.BooleanExpressionItem;
import net.starschema.clouddb.jdbc.list.Conjunction;
import net.starschema.clouddb.jdbc.list.Disjunction;
import net.starschema.clouddb.jdbc.list.Negation;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.SelectStatement;
import net.starschema.clouddb.jdbc.list.TreeBuilder;
import net.starschema.clouddb.jdbc.list.WhereExpressionJoinResolver;
import org.antlr.runtime.tree.Tree;

public class WhereExpression
extends Node {
    Node expression = null;
    SelectStatement selectStatement;
    TreeBuilder builder;

    public Node getExpression() {
        return this.expression;
    }

    public WhereExpression(Tree t, TreeBuilder treeBuilder, SelectStatement selectStatement) throws TreeParsingException {
        this.selectStatement = selectStatement;
        this.builder = treeBuilder;
        this.build(t, this.builder);
    }

    public WhereExpression(List<Node> nodeList, TreeBuilder treeBuilder, SelectStatement selectStatement) throws TreeParsingException {
        this.selectStatement = selectStatement;
        this.builder = treeBuilder;
        this.build(nodeList);
    }

    public void build(Tree t, TreeBuilder builder) throws TreeParsingException {
        if (t.getType() == 137) {
            this.tokenType = t.getType();
            this.tokenName = JdbcGrammarParser.tokenNames[this.tokenType];
            this.logger.debug("BUILDING " + this.tokenName);
            block6: for (int i = 0; i < t.getChildCount(); ++i) {
                Tree child = t.getChild(i);
                switch (child.getType()) {
                    case 35: {
                        this.expression = new Disjunction(child, builder, this, this.selectStatement);
                        continue block6;
                    }
                    case 27: {
                        this.logger.debug("BUILDING CONJUNCTION OR DISJUNCTION FROM CONJUNCTION");
                        Node built = Conjunction.buildFromConjunction(child, builder, this, this.selectStatement);
                        if (built.getTokenType() == 27) {
                            this.expression = (Node)Conjunction.class.cast(built);
                            this.logger.debug("CONJUNCTION BUILT AND ADDED TO WHEREEXPRESSION");
                            continue block6;
                        }
                        this.expression = (Node)Disjunction.class.cast(built);
                        this.logger.debug("DISJUNCTION BUILT AND ADDED TO WHEREEXPRESSION");
                        continue block6;
                    }
                    case 95: {
                        this.expression = new Negation(child, builder, this, this.selectStatement);
                        continue block6;
                    }
                    case 13: {
                        this.expression = new BooleanExpressionItem(child, builder, this, this.selectStatement);
                        continue block6;
                    }
                }
            }
        } else {
            throw new TreeParsingException("This Tree is not a WHEREEXPRESSION");
        }
    }

    public void build(List<Node> booleanExpressionToAdd) throws TreeParsingException {
        this.tokenType = 137;
        this.tokenName = JdbcGrammarParser.tokenNames[this.tokenType];
        this.logger.debug("BUILDING " + this.tokenName + "from booleanExpressions");
        if (booleanExpressionToAdd.size() == 1 && booleanExpressionToAdd.get(0).getTokenType() == 13) {
            this.expression = booleanExpressionToAdd.get(0);
            WhereExpressionJoinResolver.columnResolver((BooleanExpressionItem)this.expression, this.selectStatement);
        } else {
            this.expression = new Conjunction(booleanExpressionToAdd, this.selectStatement);
        }
    }

    @Override
    public String toPrettyString(int level) {
        return "WHERE " + this.expression.toPrettyString();
    }
}

