% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ratio.R
\name{plot_ratio}
\alias{plot_ratio}
\title{Visualise the instantaneous frequencies ratios of a
decomposition}
\usage{
plot_ratio(
  ratio,
  sqrt.rpwr = TRUE,
  style = "b",
  select = NA,
  bins = 100,
  cut = 18,
  lines = NULL,
  plot = TRUE,
  width = 10,
  height = 10,
  name = "Ratio",
  ext = ".pdf",
  dir = tempdir(),
  track = TRUE,
  openfile = TRUE
)
}
\arguments{
\item{ratio}{a ratio object (created by \code{\link{inst.ratio}}}

\item{sqrt.rpwr}{whether to use the squared ratio power (i.e. the squared
multiplication of the instantaneous amplitudes of the modes two by two)
rather than the ratio power itself.}

\item{style}{whether to plot a single plot in the graphics device ('s'), the
to plot an ensemble of all the ratios combinations in a pdf ('e'), or both
('b', is the default)}

\item{select}{the groups of ratios combinations to plot in the single plot
(in the "1/2" form)}

\item{bins, cut}{parameter for the plots: \code{bins} is fed to
\code{\link{plot_hex}}, and \code{cut} defines the number of color cuts for
\code{\link{plot_hex}}. For better control use \code{\link{plot_hex}}
directly.}

\item{lines}{the ratio of lines to be added to the plots for better
visualisation}

\item{plot}{whether to plot. Otherwise output a grob of the single plot.}

\item{width, height}{the width  and height in inches of each separate plot
in the ensemble of all the ratios combinations}

\item{name, ext, dir, track, openfile}{parameters for the pdfDisplay function,
namely the name of the pdf file, its extension (if you want to make a .svg
file you can), the directory of the file, whether to track the changes
(if you use sumatrapdf as a default pdf reader you can set it to F and it
will avoid creating too many pdf files), and whether to directly open the
file}
}
\description{
Visualise the instantaneous frequencies ratios of a
decomposition
}
\examples{
set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
  rnorm(n, sd = 0.5) + t * 0.01

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt <- cumsum(inter_dt)
dec <- extricate(xy, dt, nimf = 7, repl = 10, comb = 10,
                 factor_noise = 10, speak = TRUE)

\donttest{
plot_emd(dec, dir = tempdir())}

integrity(xy, dec)
parsimony(dec)

ht    <- inst.pulse(dec, plot = FALSE)
ratio <- inst.ratio(ht, plot = FALSE)

plot_ratio(ratio, lines = c(8), style = "s")
plot_ratio(ratio, lines = c(8), style = "s", select = c("4/6"))

\donttest{
plot_ratio(ratio, lines = c(8), style = "e", dir = tempdir())}

}
