/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.menu.OneSampleDialog;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class OneSamplePlots
extends JDialog
implements ActionListener {
    private JRadioButton plot;
    private JRadioButton noPlot;
    private JCheckBox scale;
    private JPanel okayCancelPanel;
    private JSeparator sep;
    private JLabel alphaLabel;
    private JSlider alpha;
    private JCheckBox boxPlot;
    private OneSampleDialog.OneSampleModel.PlotModel model;

    public OneSamplePlots(JDialog jDialog, OneSampleDialog.OneSampleModel.PlotModel plotModel) {
        super(jDialog);
        this.initGUI();
        this.setModel(plotModel);
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.plot = new JRadioButton();
            this.getContentPane().add(this.plot);
            this.plot.setText("Horizontal");
            this.plot.setBounds(21, 37, 102, 18);
            this.noPlot = new JRadioButton();
            this.getContentPane().add(this.noPlot);
            this.noPlot.setText("No Plot");
            this.noPlot.setBounds(21, 125, 102, 18);
            this.boxPlot = new JCheckBox();
            this.getContentPane().add(this.boxPlot);
            this.boxPlot.setText("Box plot");
            this.boxPlot.setBounds(135, 17, 180, 18);
            this.scale = new JCheckBox();
            this.getContentPane().add(this.scale);
            this.scale.setText("Scale variables");
            this.scale.setBounds(134, 42, 180, 18);
            this.alpha = new JSlider();
            this.getContentPane().add(this.alpha);
            this.alpha.setBounds(134, 85, 140, 21);
            this.alpha.setMinimum(1);
            this.alpha.setMaximum(100);
            this.alphaLabel = new JLabel();
            this.getContentPane().add(this.alphaLabel);
            this.alphaLabel.setText("Transparancy");
            this.alphaLabel.setBounds(134, 69, 140, 14);
            this.alphaLabel.setHorizontalAlignment(0);
            this.sep = new JSeparator();
            this.getContentPane().add(this.sep);
            this.sep.setBounds(45, 111, 165, 10);
            this.okayCancelPanel = new OkayCancelPanel(false, false, this);
            this.getContentPane().add(this.okayCancelPanel);
            this.okayCancelPanel.setBounds(73, 152, 182, 36);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.plot);
            buttonGroup.add(this.noPlot);
            this.setTitle("Plots");
            this.setResizable(false);
            this.setSize(275, 234);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void setModel(OneSampleDialog.OneSampleModel.PlotModel plotModel) {
        this.plot.setSelected(plotModel.plot);
        this.noPlot.setSelected(!plotModel.plot);
        this.boxPlot.setSelected(plotModel.box);
        this.scale.setSelected(plotModel.scale);
        this.alpha.setValue((int)(plotModel.alpha * 100.0));
        this.model = plotModel;
    }

    public void updateModel() {
        this.model.plot = this.plot.isSelected();
        this.model.box = this.boxPlot.isSelected();
        this.model.scale = this.scale.isSelected();
        this.model.alpha = (double)this.alpha.getValue() / 100.0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel") {
            this.dispose();
        } else if (string == "OK") {
            this.updateModel();
            this.dispose();
        }
    }
}

